/*
 * Decompiled with CFR 0.152.
 */
package charred;

public final class CharBuffer
implements CharSequence {
    public final boolean trimLeading;
    public final boolean trimTrailing;
    public final boolean nilEmpty;
    char[] buffer;
    int len;

    public CharBuffer(boolean bl, boolean bl2, boolean bl3) {
        this.trimLeading = bl;
        this.trimTrailing = bl2;
        this.nilEmpty = bl3;
        this.buffer = new char[32];
        this.len = 0;
    }

    public CharBuffer() {
        this(false, false, false);
    }

    public final char[] ensureCapacity(int n) {
        if (n >= this.buffer.length) {
            char[] cArray = new char[n * 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.len);
            this.buffer = cArray;
        }
        return this.buffer;
    }

    public final void append(char c) {
        char[] cArray = this.buffer;
        if (this.len < cArray.length) {
            cArray[this.len] = c;
            ++this.len;
            return;
        }
        cArray = this.ensureCapacity(this.len + 1);
        cArray[this.len] = c;
        ++this.len;
    }

    public final void append(char[] cArray, int n, int n2) {
        if (n < n2) {
            int n3 = this.len;
            int n4 = n2 - n;
            int n5 = n3 + n4;
            char[] cArray2 = this.ensureCapacity(n5);
            if (n4 < 5) {
                while (n < n2) {
                    cArray2[n3] = cArray[n];
                    ++n;
                    ++n3;
                }
            } else {
                System.arraycopy(cArray, n, cArray2, n3, n4);
            }
            this.len = n5;
        }
    }

    public final void append(CharSequence charSequence) {
        int n = charSequence.length();
        if (n > 0) {
            int n2 = this.len;
            int n3 = n2 + n;
            char[] cArray = this.ensureCapacity(n3);
            int n4 = 0;
            while (n4 < n) {
                cArray[n2] = charSequence.charAt(n4);
                ++n4;
                ++n2;
            }
            this.len = n3;
        }
    }

    public final void clear() {
        this.len = 0;
    }

    public char[] buffer() {
        return this.buffer;
    }

    @Override
    public final int length() {
        return this.len;
    }

    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public char charAt(int n) {
        return this.buffer[n];
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        CharBuffer charBuffer = new CharBuffer(this.trimLeading, this.trimTrailing, this.nilEmpty);
        charBuffer.append(this.buffer, n, n2);
        return charBuffer;
    }

    @Override
    public final String toString() {
        int n;
        int n2 = this.len;
        if (this.trimLeading && n2 != 0) {
            for (n = 0; n < this.len && Character.isWhitespace(this.buffer[n]); ++n) {
            }
            n2 -= n;
        }
        if (this.trimTrailing && n2 != 0) {
            int n3;
            for (n3 = this.len - 1; n3 >= n && Character.isWhitespace(this.buffer[n3]); --n3) {
            }
            n2 = n3 + 1 - n;
        }
        if (n2 == 0) {
            if (this.nilEmpty) {
                return null;
            }
            return "";
        }
        return new String(this.buffer, n, n2);
    }
}

