/*
 * Decompiled with CFR 0.152.
 */
package charred;

import java.util.function.Supplier;

public final class CharReader
implements AutoCloseable {
    Supplier<char[]> buffers;
    char[] curBuffer;
    int curPos;

    public CharReader(Supplier<char[]> supplier) {
        this.buffers = supplier;
        this.nextBuffer();
    }

    public CharReader(char[] cArray) {
        this(new SingletonData(cArray));
    }

    public CharReader(String string) {
        this(string.toCharArray());
    }

    public final char[] buffer() {
        return this.curBuffer;
    }

    public final int position() {
        return this.curPos;
    }

    public final void position(int n) {
        this.curPos = n;
    }

    public final int bufferLength() {
        return this.curBuffer != null ? this.curBuffer.length : 0;
    }

    public final int remaining() {
        return this.bufferLength() - this.curPos;
    }

    public final char eatwhite() {
        char[] cArray = this.curBuffer;
        while (cArray != null) {
            int n;
            int n2 = cArray.length;
            for (n = this.curPos; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
            }
            if (n < n2) {
                char c = cArray[n];
                this.position(n + 1);
                return c;
            }
            cArray = this.nextBuffer();
        }
        return '\u0000';
    }

    public boolean eof() {
        return this.curBuffer == null;
    }

    public final char[] nextBuffer() {
        char[] cArray = this.buffers != null ? this.buffers.get() : null;
        if (cArray != null) {
            this.curBuffer = cArray;
            this.curPos = 0;
        } else {
            this.curBuffer = null;
            this.curPos = -1;
        }
        return cArray;
    }

    public final int read() {
        if (this.remaining() > 0) {
            char c = this.curBuffer[this.curPos];
            ++this.curPos;
            return c;
        }
        this.nextBuffer();
        if (this.eof()) {
            return -1;
        }
        return this.read();
    }

    public final int read(char[] cArray, int n, int n2) {
        int n3 = n2;
        char[] cArray2 = this.curBuffer;
        while (n3 > 0 && cArray2 != null) {
            int n4 = this.curPos;
            int n5 = cArray2.length - n4;
            int n6 = Math.min(n5, n3);
            System.arraycopy(cArray2, n4, cArray, n, n6);
            n += n6;
            if ((n3 -= n6) == 0) {
                this.curPos = n4 + n6;
                return n2;
            }
            cArray2 = this.nextBuffer();
        }
        return -1;
    }

    public final void unread() {
        --this.curPos;
        if (this.curPos < 0) {
            throw new RuntimeException("Unread too far - current buffer empty");
        }
    }

    final int readFrom(int n) {
        this.curPos = n;
        return this.read();
    }

    @Override
    public void close() throws Exception {
        if (this.buffers != null) {
            if (this.buffers instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.buffers)).close();
            }
            this.buffers = null;
        }
    }

    public final String context(int n) throws Exception {
        char[] cArray = this.buffer();
        int n2 = this.position();
        int n3 = cArray.length;
        int n4 = Math.max(0, n2 - n);
        int n5 = Math.min(n3 - 1, n2 + n);
        return new String(cArray, n4, n5 - n4);
    }

    public static class SingletonData
    implements Supplier<char[]> {
        char[] data;

        SingletonData(char[] cArray) {
            this.data = cArray;
        }

        @Override
        public char[] get() {
            char[] cArray = this.data;
            this.data = null;
            return cArray;
        }
    }
}

