/*
 * Decompiled with CFR 0.152.
 */
package charred;

import charred.CharBuffer;
import charred.CharReader;
import charred.JSONReader;
import java.io.EOFException;
import java.util.List;
import java.util.function.LongPredicate;

public final class CSVReader {
    final CharReader reader;
    final char quot;
    final char sep;
    final char comment;
    public static final int EOF = -1;
    public static final int EOL = -2;
    public static final int SEP = 1;
    public static final int QUOT = 2;
    public static final int COMMENT = 3;

    public CSVReader(CharReader charReader, char c, char c2, char c3) {
        this.reader = charReader;
        this.quot = c;
        this.sep = c2;
        this.comment = c3;
    }

    final void csvReadQuote(CharBuffer charBuffer) throws EOFException {
        char[] cArray = this.reader.buffer();
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (c != this.quot) continue;
                charBuffer.append(cArray, n, i);
                if (this.reader.readFrom(i + 1) == this.quot) {
                    charBuffer.append(this.quot);
                    cArray = this.reader.buffer();
                    n2 = cArray.length;
                    n = this.reader.position();
                    i = n - 1;
                    continue;
                }
                this.reader.unread();
                return;
            }
            charBuffer.append(cArray, n, n2);
            cArray = this.reader.nextBuffer();
        }
        throw new EOFException("EOF encountered within quote - " + charBuffer.toString());
    }

    final void csvReadComment() throws EOFException {
        char[] cArray = this.reader.buffer();
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (c == '\n') {
                    this.reader.position(i + 1);
                    return;
                }
                if (c != '\r') continue;
                if (this.reader.readFrom(i + 1) != 10 && !this.reader.eof()) {
                    this.reader.unread();
                }
                return;
            }
            cArray = this.reader.nextBuffer();
        }
    }

    final int csvRead(CharBuffer charBuffer, boolean bl) throws EOFException {
        char[] cArray = this.reader.buffer();
        char c = this.sep;
        char c2 = this.quot;
        char c3 = this.comment;
        boolean bl2 = bl;
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c4 = cArray[i];
                if (c4 == c3 && bl2) {
                    this.reader.position(i + 1);
                    return 3;
                }
                if (c4 == c2) {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return 2;
                }
                if (c4 == c) {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return 1;
                }
                if (c4 == '\n') {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return -2;
                }
                if (c4 == '\r') {
                    charBuffer.append(cArray, n, i);
                    if (this.reader.readFrom(i + 1) != 10 && !this.reader.eof()) {
                        this.reader.unread();
                    }
                    return -2;
                }
                bl2 = false;
            }
            charBuffer.append(cArray, n, n2);
            cArray = this.reader.nextBuffer();
        }
        return -1;
    }

    public boolean commentsEnabled() {
        return this.comment != '\u0000';
    }

    public static final class RowReader {
        final CSVReader rdr;
        final CharBuffer sb;
        LongPredicate pred;
        final JSONReader.ArrayReader arrayReader;

        public RowReader(CharReader charReader, CharBuffer charBuffer, LongPredicate longPredicate, char c, char c2, char c3, JSONReader.ArrayReader arrayReader) {
            this.rdr = new CSVReader(charReader, c, c2, c3);
            this.sb = charBuffer;
            this.pred = longPredicate;
            this.arrayReader = arrayReader;
        }

        public void setPredicate(LongPredicate longPredicate) {
            this.pred = longPredicate;
        }

        public static final boolean emptyStr(String string) {
            return string == null || string.length() == 0;
        }

        public static final boolean emptyRow(List list) {
            int n = list.size();
            return n == 0 || n == 1 && RowReader.emptyStr((String)list.get(0));
        }

        public final Object nextRow() throws EOFException {
            int n;
            Object object = this.arrayReader.newArray();
            this.sb.clear();
            int n2 = 0;
            boolean bl = this.rdr.commentsEnabled();
            LongPredicate longPredicate = this.pred;
            do {
                n = this.rdr.csvRead(this.sb, bl);
                bl = false;
                if (n != 2) {
                    if (n == 3) {
                        this.rdr.csvReadComment();
                        continue;
                    }
                    if (longPredicate.test(n2)) {
                        object = this.arrayReader.onValue(object, this.sb.toString());
                    }
                    ++n2;
                    this.sb.clear();
                    continue;
                }
                this.rdr.csvReadQuote(this.sb);
            } while (n > 0);
            object = this.arrayReader.finalizeArray(object);
            if (n != -1 || !RowReader.emptyRow((List)object)) {
                return object;
            }
            return null;
        }
    }
}

