/*
 * Decompiled with CFR 0.152.
 */
package charred;

import charred.CharBuffer;
import charred.CharReader;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.function.LongPredicate;

public final class CSVReader {
    final CharReader reader;
    final char quot;
    final char sep;
    public static final int EOF = -1;
    public static final int EOL = -2;
    public static final int SEP = 1;
    public static final int QUOT = 2;

    public CSVReader(CharReader charReader, char c, char c2) {
        this.reader = charReader;
        this.quot = c;
        this.sep = c2;
    }

    final void csvReadQuote(CharBuffer charBuffer) throws EOFException {
        char[] cArray = this.reader.buffer();
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (c != this.quot) continue;
                charBuffer.append(cArray, n, i);
                if (this.reader.readFrom(i + 1) == this.quot) {
                    charBuffer.append(this.quot);
                    cArray = this.reader.buffer();
                    n2 = cArray.length;
                    n = this.reader.position();
                    i = n - 1;
                    continue;
                }
                this.reader.unread();
                return;
            }
            charBuffer.append(cArray, n, n2);
            cArray = this.reader.nextBuffer();
        }
        throw new EOFException("EOF encountered within quote");
    }

    final int csvRead(CharBuffer charBuffer) throws EOFException {
        char[] cArray = this.reader.buffer();
        char c = this.sep;
        char c2 = this.quot;
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c3 = cArray[i];
                if (c3 == c2) {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return 2;
                }
                if (c3 == c) {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return 1;
                }
                if (c3 == '\n') {
                    charBuffer.append(cArray, n, i);
                    this.reader.position(i + 1);
                    return -2;
                }
                if (c3 != '\r') continue;
                charBuffer.append(cArray, n, i);
                if (this.reader.readFrom(i + 1) != 10) {
                    this.reader.unread();
                }
                return -2;
            }
            charBuffer.append(cArray, n, n2);
            cArray = this.reader.nextBuffer();
        }
        return -1;
    }

    public static final class RowReader {
        final CSVReader rdr;
        final CharBuffer sb;
        LongPredicate pred;

        public RowReader(CharReader charReader, CharBuffer charBuffer, LongPredicate longPredicate, char c, char c2) {
            this.rdr = new CSVReader(charReader, c, c2);
            this.sb = charBuffer;
            this.pred = longPredicate;
        }

        public void setPredicate(LongPredicate longPredicate) {
            this.pred = longPredicate;
        }

        public static final boolean emptyStr(String string) {
            return string == null || string.length() == 0;
        }

        public static final boolean emptyRow(ArrayList<String> arrayList) {
            int n = arrayList.size();
            return n == 0 || n == 1 && RowReader.emptyStr(arrayList.get(0));
        }

        public final ArrayList<String> nextRow() throws EOFException {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>(8);
            this.sb.clear();
            int n2 = 0;
            LongPredicate longPredicate = this.pred;
            do {
                if ((n = this.rdr.csvRead(this.sb)) != 2) {
                    if (longPredicate.test(n2)) {
                        arrayList.add(this.sb.toString());
                    }
                    ++n2;
                    this.sb.clear();
                    continue;
                }
                this.rdr.csvReadQuote(this.sb);
            } while (n > 0);
            if (n != -1 || !RowReader.emptyRow(arrayList)) {
                return arrayList;
            }
            return null;
        }
    }
}

