/*
 * Decompiled with CFR 0.152.
 */
package charred;

import charred.CharBuffer;
import clojure.lang.Ratio;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public class JSONWriter
implements AutoCloseable {
    int indent;
    public final Writer w;
    public final boolean escapeJSSep;
    public final boolean escapeSlash;
    public final boolean escapeUnicode;
    public final String indentStr;
    public final BiConsumer<JSONWriter, Object> objConsumer;
    final CharBuffer charBuffer;

    public JSONWriter(Writer writer, boolean bl, boolean bl2, boolean bl3, String string, BiConsumer<JSONWriter, Object> biConsumer) {
        this.w = writer;
        this.indent = 0;
        this.charBuffer = new CharBuffer();
        this.escapeJSSep = bl;
        this.escapeSlash = bl2;
        this.escapeUnicode = bl3;
        this.indentStr = string != null && string.length() != 0 ? string : null;
        this.objConsumer = biConsumer;
    }

    public int indent() {
        return this.indent;
    }

    public void indent(int n) {
        this.indent = n;
    }

    public CharBuffer charBuffer() {
        this.charBuffer.clear();
        return this.charBuffer;
    }

    public static void escape(CharBuffer charBuffer, char c) {
        charBuffer.append('\\');
        charBuffer.append(c);
    }

    public static void toHexString(CharBuffer charBuffer, char c) {
        JSONWriter.escape(charBuffer, 'u');
        String string = Integer.toHexString(c);
        switch (string.length()) {
            case 1: {
                charBuffer.append('0');
                charBuffer.append('0');
                charBuffer.append('0');
                break;
            }
            case 2: {
                charBuffer.append('0');
                charBuffer.append('0');
                break;
            }
            case 3: {
                charBuffer.append('0');
            }
        }
        charBuffer.append(string);
    }

    public static void writeBuffer(Writer writer, CharBuffer charBuffer) throws IOException {
        writer.write(charBuffer.buffer(), 0, charBuffer.length());
    }

    public static boolean isJSSep(char c) {
        return c == '\u2028' || c == '\u2029';
    }

    public void writeString(CharSequence charSequence) throws IOException {
        CharBuffer charBuffer = this.charBuffer();
        charBuffer.append('\"');
        int n = charSequence.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    JSONWriter.escape(charBuffer, c);
                    continue block9;
                }
                case '/': {
                    if (this.escapeSlash) {
                        JSONWriter.escape(charBuffer, c);
                        continue block9;
                    }
                    charBuffer.append(c);
                    continue block9;
                }
                case '\f': {
                    JSONWriter.escape(charBuffer, 'f');
                    continue block9;
                }
                case '\n': {
                    JSONWriter.escape(charBuffer, 'n');
                    continue block9;
                }
                case '\r': {
                    JSONWriter.escape(charBuffer, 'r');
                    continue block9;
                }
                case '\b': {
                    JSONWriter.escape(charBuffer, 'b');
                    continue block9;
                }
                case '\t': {
                    JSONWriter.escape(charBuffer, 't');
                    continue block9;
                }
                default: {
                    if (c < ' ' || this.escapeJSSep && JSONWriter.isJSSep(c)) {
                        JSONWriter.toHexString(charBuffer, c);
                        continue block9;
                    }
                    if (this.escapeUnicode && c >= '\u0080') {
                        JSONWriter.toHexString(charBuffer, c);
                        continue block9;
                    }
                    charBuffer.append(c);
                }
            }
        }
        charBuffer.append('\"');
        JSONWriter.writeBuffer(this.w, charBuffer);
    }

    public void writeNumber(Number number) throws Exception {
        Float f;
        if (number instanceof Ratio) {
            number = ((Ratio)number).doubleValue();
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            if (!Double.isFinite(d)) {
                if (Double.isNaN(d)) {
                    throw new Exception("JSON encoding error - NAN detected");
                }
                throw new Exception("JSON encoding error - +/-INF detected");
            }
        } else if (number instanceof Float && !Float.isFinite((f = (Float)number).floatValue())) {
            if (Float.isNaN(f.floatValue())) {
                throw new Exception("JSON encoding error - NAN detected");
            }
            throw new Exception("JSON encoding error - +/-INF detected");
        }
        this.w.write(number.toString());
    }

    public void writeIndent() throws Exception {
        if (this.indent == 0 || this.indentStr == null) {
            return;
        }
        if (this.indent == 1) {
            this.w.write(this.indentStr);
        } else {
            for (int i = 0; i < this.indent; ++i) {
                this.w.write(this.indentStr);
            }
        }
    }

    public void writeObject(Object object) throws Exception {
        BiConsumer<JSONWriter, Object> biConsumer = this.objConsumer;
        if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Number) {
            this.writeNumber((Number)object);
        } else if (object == null) {
            this.w.write("null");
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.w.write("true");
            } else {
                this.w.write("false");
            }
        } else {
            biConsumer.accept(this, object);
        }
    }

    public void writeArray(Iterator<Object> iterator) throws Exception {
        ++this.indent;
        this.w.write(91);
        boolean bl = true;
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            if (!bl) {
                this.w.write(44);
            }
            bl = false;
            this.writeObject(iterator.next());
            bl2 = iterator.hasNext();
        }
        this.w.write(93);
        --this.indent;
    }

    public void writeMap(Iterator<Map.Entry> iterator) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.indentStr != null;
        if (bl) {
            if (this.indent != 0) {
                this.w.write(10);
            }
            this.writeIndent();
        }
        this.w.write(123);
        ++this.indent;
        boolean bl3 = true;
        boolean bl4 = iterator.hasNext();
        while (bl4) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!(k instanceof String)) {
                throw new Exception("JSON encoding error - Map keys must be strings");
            }
            if (!bl3) {
                this.w.write(",");
            }
            if (bl) {
                this.w.write(10);
                this.writeIndent();
            }
            bl3 = false;
            this.writeString((String)k);
            this.w.write(": ");
            this.writeObject(v);
            bl4 = iterator.hasNext();
        }
        --this.indent;
        if (bl && !bl3) {
            this.w.write(10);
            this.writeIndent();
        }
        this.w.write(125);
    }

    @Override
    public void close() throws Exception {
        this.w.close();
    }
}

