(ns avclj.av-pixfmt-data
  (:require [tech.v3.datatype.errors :as errors]))



(defmacro ^:private define-pixfmt-constants
  [pixfmts]
  `(do
     (def pixfmt-name-value-map ~pixfmts)
     ~@(->> pixfmts
            (map (fn [[k v]]
                   (let [sym (with-meta (symbol k)
                               {:tag ''long})]
                     `(def ~sym ~v)))))))


(define-pixfmt-constants
 { "AV_PIX_FMT_NONE" -1
   "AV_PIX_FMT_YUV420P" 0
   "AV_PIX_FMT_YUYV422" 1
   "AV_PIX_FMT_RGB24" 2
   "AV_PIX_FMT_BGR24" 3
   "AV_PIX_FMT_YUV422P" 4
   "AV_PIX_FMT_YUV444P" 5
   "AV_PIX_FMT_YUV410P" 6
   "AV_PIX_FMT_YUV411P" 7
   "AV_PIX_FMT_GRAY8" 8
   "AV_PIX_FMT_MONOWHITE" 9
   "AV_PIX_FMT_MONOBLACK" 10
   "AV_PIX_FMT_PAL8" 11
   "AV_PIX_FMT_YUVJ420P" 12
   "AV_PIX_FMT_YUVJ422P" 13
   "AV_PIX_FMT_YUVJ444P" 14
   "AV_PIX_FMT_UYVY422" 15
   "AV_PIX_FMT_UYYVYY411" 16
   "AV_PIX_FMT_BGR8" 17
   "AV_PIX_FMT_BGR4" 18
   "AV_PIX_FMT_BGR4_BYTE" 19
   "AV_PIX_FMT_RGB8" 20
   "AV_PIX_FMT_RGB4" 21
   "AV_PIX_FMT_RGB4_BYTE" 22
   "AV_PIX_FMT_NV12" 23
   "AV_PIX_FMT_NV21" 24
   "AV_PIX_FMT_ARGB" 25
   "AV_PIX_FMT_RGBA" 26
   "AV_PIX_FMT_ABGR" 27
   "AV_PIX_FMT_BGRA" 28
   "AV_PIX_FMT_GRAY16BE" 29
   "AV_PIX_FMT_GRAY16LE" 30
   "AV_PIX_FMT_YUV440P" 31
   "AV_PIX_FMT_YUVJ440P" 32
   "AV_PIX_FMT_YUVA420P" 33
   "AV_PIX_FMT_RGB48BE" 34
   "AV_PIX_FMT_RGB48LE" 35
   "AV_PIX_FMT_RGB565BE" 36
   "AV_PIX_FMT_RGB565LE" 37
   "AV_PIX_FMT_RGB555BE" 38
   "AV_PIX_FMT_RGB555LE" 39
   "AV_PIX_FMT_BGR565BE" 40
   "AV_PIX_FMT_BGR565LE" 41
   "AV_PIX_FMT_BGR555BE" 42
   "AV_PIX_FMT_BGR555LE" 43
   "AV_PIX_FMT_VAAPI" 46
   "AV_PIX_FMT_YUV420P16LE" 47
   "AV_PIX_FMT_YUV420P16BE" 48
   "AV_PIX_FMT_YUV422P16LE" 49
   "AV_PIX_FMT_YUV422P16BE" 50
   "AV_PIX_FMT_YUV444P16LE" 51
   "AV_PIX_FMT_YUV444P16BE" 52
   "AV_PIX_FMT_DXVA2_VLD" 53
   "AV_PIX_FMT_RGB444LE" 54
   "AV_PIX_FMT_RGB444BE" 55
   "AV_PIX_FMT_BGR444LE" 56
   "AV_PIX_FMT_BGR444BE" 57
   "AV_PIX_FMT_YA8" 58
   "AV_PIX_FMT_Y400A" 58
   "AV_PIX_FMT_GRAY8A" 58
   "AV_PIX_FMT_BGR48BE" 59
   "AV_PIX_FMT_BGR48LE" 60
   "AV_PIX_FMT_YUV420P9BE" 61
   "AV_PIX_FMT_YUV420P9LE" 62
   "AV_PIX_FMT_YUV420P10BE" 63
   "AV_PIX_FMT_YUV420P10LE" 64
   "AV_PIX_FMT_YUV422P10BE" 65
   "AV_PIX_FMT_YUV422P10LE" 66
   "AV_PIX_FMT_YUV444P9BE" 67
   "AV_PIX_FMT_YUV444P9LE" 68
   "AV_PIX_FMT_YUV444P10BE" 69
   "AV_PIX_FMT_YUV444P10LE" 70
   "AV_PIX_FMT_YUV422P9BE" 71
   "AV_PIX_FMT_YUV422P9LE" 72
   "AV_PIX_FMT_GBRP" 73
   "AV_PIX_FMT_GBR24P" 73
   "AV_PIX_FMT_GBRP9BE" 74
   "AV_PIX_FMT_GBRP9LE" 75
   "AV_PIX_FMT_GBRP10BE" 76
   "AV_PIX_FMT_GBRP10LE" 77
   "AV_PIX_FMT_GBRP16BE" 78
   "AV_PIX_FMT_GBRP16LE" 79
   "AV_PIX_FMT_YUVA422P" 80
   "AV_PIX_FMT_YUVA444P" 81
   "AV_PIX_FMT_YUVA420P9BE" 82
   "AV_PIX_FMT_YUVA420P9LE" 83
   "AV_PIX_FMT_YUVA422P9BE" 84
   "AV_PIX_FMT_YUVA422P9LE" 85
   "AV_PIX_FMT_YUVA444P9BE" 86
   "AV_PIX_FMT_YUVA444P9LE" 87
   "AV_PIX_FMT_YUVA420P10BE" 88
   "AV_PIX_FMT_YUVA420P10LE" 89
   "AV_PIX_FMT_YUVA422P10BE" 90
   "AV_PIX_FMT_YUVA422P10LE" 91
   "AV_PIX_FMT_YUVA444P10BE" 92
   "AV_PIX_FMT_YUVA444P10LE" 93
   "AV_PIX_FMT_YUVA420P16BE" 94
   "AV_PIX_FMT_YUVA420P16LE" 95
   "AV_PIX_FMT_YUVA422P16BE" 96
   "AV_PIX_FMT_YUVA422P16LE" 97
   "AV_PIX_FMT_YUVA444P16BE" 98
   "AV_PIX_FMT_YUVA444P16LE" 99
   "AV_PIX_FMT_VDPAU" 100
   "AV_PIX_FMT_XYZ12LE" 101
   "AV_PIX_FMT_XYZ12BE" 102
   "AV_PIX_FMT_NV16" 103
   "AV_PIX_FMT_NV20LE" 104
   "AV_PIX_FMT_NV20BE" 105
   "AV_PIX_FMT_RGBA64BE" 106
   "AV_PIX_FMT_RGBA64LE" 107
   "AV_PIX_FMT_BGRA64BE" 108
   "AV_PIX_FMT_BGRA64LE" 109
   "AV_PIX_FMT_YVYU422" 110
   "AV_PIX_FMT_YA16BE" 111
   "AV_PIX_FMT_YA16LE" 112
   "AV_PIX_FMT_GBRAP" 113
   "AV_PIX_FMT_GBRAP16BE" 114
   "AV_PIX_FMT_GBRAP16LE" 115
   "AV_PIX_FMT_QSV" 116
   "AV_PIX_FMT_MMAL" 117
   "AV_PIX_FMT_D3D11VA_VLD" 118
   "AV_PIX_FMT_CUDA" 119
   "AV_PIX_FMT_0RGB" 120
   "AV_PIX_FMT_RGB0" 121
   "AV_PIX_FMT_0BGR" 122
   "AV_PIX_FMT_BGR0" 123
   "AV_PIX_FMT_YUV420P12BE" 124
   "AV_PIX_FMT_YUV420P12LE" 125
   "AV_PIX_FMT_YUV420P14BE" 126
   "AV_PIX_FMT_YUV420P14LE" 127
   "AV_PIX_FMT_YUV422P12BE" 128
   "AV_PIX_FMT_YUV422P12LE" 129
   "AV_PIX_FMT_YUV422P14BE" 130
   "AV_PIX_FMT_YUV422P14LE" 131
   "AV_PIX_FMT_YUV444P12BE" 132
   "AV_PIX_FMT_YUV444P12LE" 133
   "AV_PIX_FMT_YUV444P14BE" 134
   "AV_PIX_FMT_YUV444P14LE" 135
   "AV_PIX_FMT_GBRP12BE" 136
   "AV_PIX_FMT_GBRP12LE" 137
   "AV_PIX_FMT_GBRP14BE" 138
   "AV_PIX_FMT_GBRP14LE" 139
   "AV_PIX_FMT_YUVJ411P" 140
   "AV_PIX_FMT_BAYER_BGGR8" 141
   "AV_PIX_FMT_BAYER_RGGB8" 142
   "AV_PIX_FMT_BAYER_GBRG8" 143
   "AV_PIX_FMT_BAYER_GRBG8" 144
   "AV_PIX_FMT_BAYER_BGGR16LE" 145
   "AV_PIX_FMT_BAYER_BGGR16BE" 146
   "AV_PIX_FMT_BAYER_RGGB16LE" 147
   "AV_PIX_FMT_BAYER_RGGB16BE" 148
   "AV_PIX_FMT_BAYER_GBRG16LE" 149
   "AV_PIX_FMT_BAYER_GBRG16BE" 150
   "AV_PIX_FMT_BAYER_GRBG16LE" 151
   "AV_PIX_FMT_BAYER_GRBG16BE" 152
   "AV_PIX_FMT_XVMC" 153
   "AV_PIX_FMT_YUV440P10LE" 154
   "AV_PIX_FMT_YUV440P10BE" 155
   "AV_PIX_FMT_YUV440P12LE" 156
   "AV_PIX_FMT_YUV440P12BE" 157
   "AV_PIX_FMT_AYUV64LE" 158
   "AV_PIX_FMT_AYUV64BE" 159
   "AV_PIX_FMT_VIDEOTOOLBOX" 160
   "AV_PIX_FMT_P010LE" 161
   "AV_PIX_FMT_P010BE" 162
   "AV_PIX_FMT_GBRAP12BE" 163
   "AV_PIX_FMT_GBRAP12LE" 164
   "AV_PIX_FMT_GBRAP10BE" 165
   "AV_PIX_FMT_GBRAP10LE" 166
   "AV_PIX_FMT_MEDIACODEC" 167
   "AV_PIX_FMT_GRAY12BE" 168
   "AV_PIX_FMT_GRAY12LE" 169
   "AV_PIX_FMT_GRAY10BE" 170
   "AV_PIX_FMT_GRAY10LE" 171
   "AV_PIX_FMT_P016LE" 172
   "AV_PIX_FMT_P016BE" 173
   "AV_PIX_FMT_D3D11" 174
   "AV_PIX_FMT_GRAY9BE" 175
   "AV_PIX_FMT_GRAY9LE" 176
   "AV_PIX_FMT_GBRPF32BE" 177
   "AV_PIX_FMT_GBRPF32LE" 178
   "AV_PIX_FMT_GBRAPF32BE" 179
   "AV_PIX_FMT_GBRAPF32LE" 180
   "AV_PIX_FMT_DRM_PRIME" 181
   "AV_PIX_FMT_OPENCL" 182
   "AV_PIX_FMT_GRAY14BE" 183
   "AV_PIX_FMT_GRAY14LE" 184
   "AV_PIX_FMT_GRAYF32BE" 185
   "AV_PIX_FMT_GRAYF32LE" 186
   "AV_PIX_FMT_YUVA422P12BE" 187
   "AV_PIX_FMT_YUVA422P12LE" 188
   "AV_PIX_FMT_YUVA444P12BE" 189
   "AV_PIX_FMT_YUVA444P12LE" 190
   "AV_PIX_FMT_NV24" 191
   "AV_PIX_FMT_NV42" 192
   "AV_PIX_FMT_VULKAN" 193
   "AV_PIX_FMT_Y210BE" 194
   "AV_PIX_FMT_Y210LE" 195
   "AV_PIX_FMT_X2RGB10LE" 196
   "AV_PIX_FMT_X2RGB10BE" 197
   "AV_PIX_FMT_NB" 198
   "AV_PIX_FMT_RGB32" 28
   "AV_PIX_FMT_RGB32_1" 27
   "AV_PIX_FMT_BGR32" 26
   "AV_PIX_FMT_BGR32_1" 25
   "AV_PIX_FMT_0RGB32" 123
   "AV_PIX_FMT_0BGR32" 121
   "AV_PIX_FMT_GRAY9" 176
   "AV_PIX_FMT_GRAY10" 171
   "AV_PIX_FMT_GRAY12" 169
   "AV_PIX_FMT_GRAY14" 184
   "AV_PIX_FMT_GRAY16" 30
   "AV_PIX_FMT_YA16" 112
   "AV_PIX_FMT_RGB48" 35
   "AV_PIX_FMT_RGB565" 37
   "AV_PIX_FMT_RGB555" 39
   "AV_PIX_FMT_RGB444" 54
   "AV_PIX_FMT_RGBA64" 107
   "AV_PIX_FMT_BGR48" 60
   "AV_PIX_FMT_BGR565" 41
   "AV_PIX_FMT_BGR555" 43
   "AV_PIX_FMT_BGR444" 56
   "AV_PIX_FMT_BGRA64" 109
   "AV_PIX_FMT_YUV420P9" 62
   "AV_PIX_FMT_YUV422P9" 72
   "AV_PIX_FMT_YUV444P9" 68
   "AV_PIX_FMT_YUV420P10" 64
   "AV_PIX_FMT_YUV422P10" 66
   "AV_PIX_FMT_YUV440P10" 154
   "AV_PIX_FMT_YUV444P10" 70
   "AV_PIX_FMT_YUV420P12" 125
   "AV_PIX_FMT_YUV422P12" 129
   "AV_PIX_FMT_YUV440P12" 156
   "AV_PIX_FMT_YUV444P12" 133
   "AV_PIX_FMT_YUV420P14" 127
   "AV_PIX_FMT_YUV422P14" 131
   "AV_PIX_FMT_YUV444P14" 135
   "AV_PIX_FMT_YUV420P16" 47
   "AV_PIX_FMT_YUV422P16" 49
   "AV_PIX_FMT_YUV444P16" 51
   "AV_PIX_FMT_GBRP9" 75
   "AV_PIX_FMT_GBRP10" 77
   "AV_PIX_FMT_GBRP12" 137
   "AV_PIX_FMT_GBRP14" 139
   "AV_PIX_FMT_GBRP16" 79
   "AV_PIX_FMT_GBRAP10" 166
   "AV_PIX_FMT_GBRAP12" 164
   "AV_PIX_FMT_GBRAP16" 115
   "AV_PIX_FMT_BAYER_BGGR16" 145
   "AV_PIX_FMT_BAYER_RGGB16" 147
   "AV_PIX_FMT_BAYER_GBRG16" 149
   "AV_PIX_FMT_BAYER_GRBG16" 151
   "AV_PIX_FMT_GBRPF32" 178
   "AV_PIX_FMT_GBRAPF32" 180
   "AV_PIX_FMT_GRAYF32" 186
   "AV_PIX_FMT_YUVA420P9" 83
   "AV_PIX_FMT_YUVA422P9" 85
   "AV_PIX_FMT_YUVA444P9" 87
   "AV_PIX_FMT_YUVA420P10" 89
   "AV_PIX_FMT_YUVA422P10" 91
   "AV_PIX_FMT_YUVA444P10" 93
   "AV_PIX_FMT_YUVA422P12" 188
   "AV_PIX_FMT_YUVA444P12" 190
   "AV_PIX_FMT_YUVA420P16" 95
   "AV_PIX_FMT_YUVA422P16" 97
   "AV_PIX_FMT_YUVA444P16" 99
   "AV_PIX_FMT_XYZ12" 101
   "AV_PIX_FMT_NV20" 104
   "AV_PIX_FMT_AYUV64" 158
   "AV_PIX_FMT_P010" 161
   "AV_PIX_FMT_P016" 172
   "AV_PIX_FMT_Y210" 195
   "AV_PIX_FMT_X2RGB10" 196})


(defn pixfmt->value
  [pixfmt]
  (if-let [retval (get pixfmt-name-value-map pixfmt)]
    retval
    (errors/throwf "Unrecognized pixel format: %s" pixfmt)))


(def pixfmt-value-name-multi-map (->> pixfmt-name-value-map
                                      (map (fn [[k v]]
                                             [v k]))
                                      (group-by first)
                                      (map (fn [[k vs]]
                                             [k (mapv second vs)]))
                                      (into {})))


(defn value->pixfmt
  [pixval]
  (if-let [retval (get pixfmt-value-name-multi-map pixval)]
    retval
    [(format "Unrecognized pixfmt %s" pixval)]))


(comment
  (require '[tech.v3.datatype.export-symbols :as export-symbols])

  (export-symbols/write-api! 'avclj.av-pixfmt-data
                             'avclj.av-pixfmt
                             "src/avclj/av_pixfmt.clj"
                             nil)
  )
