/*
 * Decompiled with CFR 0.152.
 */
package jvm_hiccup_meter;

import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private static boolean allocateObjects = true;
    public volatile Long lastSleepTimeObj;
    private LongConsumer callback;
    private int resolutionMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 10);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-hiccup-metter-thread");
        this.callback = longConsumer;
        this.resolutionMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = (long)this.resolutionMs * 1000L * 1000L;
        try {
            long l2 = Long.MAX_VALUE;
            long l3 = Long.MAX_VALUE;
            while (this.doRun) {
                TimeUnit.NANOSECONDS.sleep(l);
                if (allocateObjects) {
                    this.lastSleepTimeObj = new Long(l3);
                }
                long l4 = System.nanoTime();
                long l5 = l4 - l3;
                l3 = l4;
                if (l5 < 0L) continue;
                if (l5 < l2) {
                    l2 = l5;
                }
                long l6 = l5 - l2;
                this.callback.accept(l6);
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }
}

