/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import com.sun.management.ThreadMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private LongConsumer callback;
    private int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        BigInteger bigInteger = BigInteger.valueOf(-1L);
        try {
            while (this.doRun) {
                long l4 = MeterThread.usedHeap();
                long l5 = MeterThread.gcCounts();
                BigInteger bigInteger2 = MeterThread.allocatedByAllThreads();
                long l6 = System.currentTimeMillis();
                double d = 1000.0 / (double)(l6 - l);
                long l7 = l4 - l2;
                if (l != 0L) {
                    long l8;
                    if (l5 == l3 && l7 >= 0L) {
                        l8 = Math.round((double)l7 * d);
                        this.callback.accept(l8);
                    } else if (bigInteger2.compareTo(BigInteger.ZERO) >= 0 && bigInteger.compareTo(BigInteger.ZERO) >= 0 && bigInteger2.compareTo(BigInteger.ZERO) >= 0) {
                        l8 = Math.round((double)bigInteger2.subtract(bigInteger).longValue() * d);
                        this.callback.accept(l8);
                    }
                }
                Thread.sleep(this.intervalMs);
                l = l6;
                l2 = l4;
                l3 = l5;
                bigInteger = bigInteger2;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private static long usedHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private static long gcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }

    private static BigInteger allocatedByAllThreads() {
        ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        long[] lArray2 = threadMXBean.getThreadAllocatedBytes(lArray);
        BigInteger bigInteger = BigInteger.ZERO;
        for (long l : lArray2) {
            bigInteger = bigInteger.add(BigInteger.valueOf(l));
        }
        return bigInteger;
    }
}

