/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import com.sun.management.ThreadMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private LongConsumer callback;
    private int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = -1L;
        try {
            while (this.doRun) {
                long l5 = MeterThread.usedHeap();
                long l6 = MeterThread.gcCounts();
                long l7 = MeterThread.allocatedByAllThreads();
                long l8 = System.currentTimeMillis();
                double d = 1000.0 / (double)(l8 - l);
                long l9 = l5 - l2;
                long l10 = l7 - l4;
                if (l != 0L) {
                    long l11;
                    if (l6 == l3 && l9 >= 0L) {
                        l11 = Math.round((double)l9 * d);
                        this.callback.accept(l11);
                    } else if (l10 >= 0L) {
                        l11 = Math.round((double)l10 * d);
                        this.callback.accept(l11);
                    }
                }
                Thread.sleep(this.intervalMs);
                l = l8;
                l2 = l5;
                l3 = l6;
                l4 = l7;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private static long usedHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private static long gcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }

    private static long allocatedByAllThreads() {
        ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        long[] lArray2 = threadMXBean.getThreadAllocatedBytes(lArray);
        long l = 0L;
        for (long l2 : lArray2) {
            l += l2;
        }
        return l;
    }
}

