/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private LongConsumer callback;
    private int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = -1L;
        try {
            while (this.doRun) {
                long l3 = MeterThread.allocatedByAllThreads();
                long l4 = System.currentTimeMillis();
                if (l2 != -1L) {
                    long l5 = l4 - l;
                    long l6 = l3 - l2;
                    if (l6 > 0L) {
                        long l7 = Math.round((double)l6 * 1000.0 / (double)l5);
                        this.callback.accept(l7);
                    }
                }
                Thread.sleep(this.intervalMs);
                l2 = l3;
                l = l4;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private static long allocatedByAllThreads() {
        ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        long[] lArray2 = threadMXBean.getThreadAllocatedBytes(lArray);
        long l = 0L;
        for (long l2 : lArray2) {
            l += l2;
        }
        return l;
    }
}

