/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private LongConsumer callback;
    private int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        try {
            long l2 = -1L;
            long l3 = -1L;
            while (this.doRun) {
                long l4 = MeterThread.usedHeap();
                long l5 = MeterThread.gcCounts();
                long l6 = System.currentTimeMillis();
                if (l5 == l3 && l4 >= l2) {
                    long l7 = l6 - l;
                    long l8 = Math.round((double)(l4 - l2) * (1000.0 / (double)l7));
                    this.callback.accept(l8);
                }
                Thread.sleep(this.intervalMs);
                l2 = l4;
                l3 = l5;
                l = l6;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private static long usedHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private static long gcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }
}

