/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private LongConsumer callback;
    private int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        double d = 1000.0 / (double)this.intervalMs;
        try {
            long l = -1L;
            long l2 = -1L;
            while (this.doRun) {
                long l3 = MeterThread.usedHeap();
                long l4 = MeterThread.gcCounts();
                if (l4 == l2 && l3 >= l) {
                    long l5 = Math.round((double)(l3 - l) * d);
                    this.callback.accept(l5);
                }
                Thread.sleep(this.intervalMs);
                l = l3;
                l2 = l4;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private static long usedHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private static long gcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }
}

