/*
 * Decompiled with CFR 0.152.
 */
package clj_async_profiler;

import clojure.lang.Compiler;
import java.util.Map;

public class Helpers {
    public static String safeSubs(String string, int n, int n2) {
        int n3 = string.length();
        return n >= 0 && n2 <= n3 && n <= n2 ? string.substring(n, n2) : "";
    }

    public static boolean frameHasSpecialChar(String string) {
        int n = string.length();
        int n2 = 0;
        do {
            int n3 = string.indexOf("_", n2);
            n2 = n3 + 1;
            if (n3 != -1) continue;
            return false;
        } while (n2 >= n || !Character.isUpperCase(string.charAt(n2)));
        return true;
    }

    public static String demungeJavaClojureFrames(String string) {
        return Helpers.demungeJavaClojureFrames(string, null);
    }

    public static String demungeJavaClojureFrames(String string, Map<String, String> map) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(";", n2);
            if (n3 == -1) {
                n3 = n;
            }
            int n4 = string.lastIndexOf(".", n3);
            int n5 = string.indexOf("/", n2);
            if (n2 > 0) {
                stringBuilder.append(";");
            }
            if (n5 > -1 && n5 < n3 && n4 > n2) {
                String string3;
                String string4 = string.substring(n4 + 1, n3);
                if ((string4.equals("invoke") || string4.equals("doInvoke") || string4.equals("invokeStatic") || string4.equals("invokePrim")) && !"clojure/lang/".equals(Helpers.safeSubs(string, n2, n2 + 13))) {
                    String string5;
                    string3 = string.substring(n2, n4);
                    String string6 = string3.replace('/', '.');
                    if (Helpers.frameHasSpecialChar(string6)) {
                        if (map != null) {
                            string5 = string6;
                            string6 = map.computeIfAbsent(string5, string2 -> Compiler.demunge((String)string5));
                        } else {
                            string6 = Compiler.demunge((String)string6);
                        }
                    } else {
                        string6 = string6.replace('_', '-').replace('$', '/');
                    }
                    stringBuilder.append(string6);
                    string5 = string3.concat(".invokeStatic");
                    int n6 = Math.min(n3 + 1 + string5.length(), n);
                    if (string5.equals(Helpers.safeSubs(string, n3 + 1, n6))) {
                        n2 = Math.min(n6 + 1, n);
                        continue;
                    }
                    n2 = n3 + 1;
                    continue;
                }
                string3 = string.substring(n2, n3).replace('/', '.');
                stringBuilder.append(string3);
                n2 = n3 + 1;
                continue;
            }
            stringBuilder.append(string, n2, n3);
            n2 = n3 + 1;
        }
        return stringBuilder.toString();
    }

    public static String removeLambdaIds(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5 = -1;
            int n6 = -1;
            for (n4 = n2; n4 < n; ++n4) {
                if (!Character.isDigit(string.charAt(n4))) continue;
                n6 = n4;
                break;
            }
            if (n6 == -1) break;
            for (n4 = n6 + 1; n4 < n; ++n4) {
                if (Character.isDigit(string.charAt(n4))) continue;
                n5 = n4;
                break;
            }
            if (n5 == -1) {
                n5 = n;
            }
            if (n6 >= 1 && string.charAt(n6 - 1) == '.' || n6 >= 1 && string.charAt(n6 - 1) == '$' || n6 >= 2 && string.charAt(n6 - 2) == '-' && string.charAt(n6 - 1) == '-' || n6 >= 2 && string.charAt(n6 - 2) == '_' && string.charAt(n6 - 1) == '_' || n6 >= 4 && string.charAt(n6 - 4) == 'e' && string.charAt(n6 - 3) == 'v' && string.charAt(n6 - 2) == 'a' && string.charAt(n6 - 1) == 'l') {
                stringBuilder.append(string, n3, n6);
                n3 = n5;
            }
            n2 = n5;
        }
        return n3 == 0 ? string : stringBuilder.append(string, n3, n).toString();
    }
}

