/*
 * Decompiled with CFR 0.152.
 */
package clj_async_profiler;

import clojure.lang.Compiler;
import java.util.Map;

public class Helpers {
    public static String safeSubs(String string, int n, int n2) {
        int n3 = string.length();
        return n >= 0 && n2 <= n3 && n <= n2 ? string.substring(n, n2) : "";
    }

    public static boolean frameHasSpecialChar(String string) {
        int n = string.length();
        int n2 = 0;
        do {
            int n3 = string.indexOf("_", n2);
            n2 = n3 + 1;
            if (n3 != -1) continue;
            return false;
        } while (n2 >= n || !Character.isUpperCase(string.charAt(n2)));
        return true;
    }

    public static String demungeJavaClojureFrames(String string) {
        return Helpers.demungeJavaClojureFrames(string, null);
    }

    public static String demungeJavaClojureFrames(String string, Map<String, String> map) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(";", n2);
            if (n3 == -1) {
                n3 = n;
            }
            int n4 = string.lastIndexOf(".", n3);
            int n5 = string.indexOf("/", n2);
            if (n2 > 0) {
                stringBuilder.append(";");
            }
            if (n5 > -1 && n5 < n3 && n4 > n2) {
                String string3;
                String string4 = string.substring(n4 + 1, n3);
                if ((string4.equals("invoke") || string4.equals("doInvoke") || string4.equals("invokeStatic") || string4.equals("invokePrim")) && !"clojure/lang/".equals(Helpers.safeSubs(string, n2, n2 + 13))) {
                    String string5;
                    string3 = string.substring(n2, n4);
                    String string6 = string3.replace('/', '.');
                    if (Helpers.frameHasSpecialChar(string6)) {
                        if (map != null) {
                            string5 = string6;
                            string6 = map.computeIfAbsent(string5, string2 -> Compiler.demunge((String)string5));
                        } else {
                            string6 = Compiler.demunge((String)string6);
                        }
                    } else {
                        string6 = string6.replace('_', '-').replace('$', '/');
                    }
                    stringBuilder.append(string6);
                    string5 = string3.concat(".invokeStatic");
                    int n6 = Math.min(n3 + 1 + string5.length(), n);
                    if (string5.equals(Helpers.safeSubs(string, n3 + 1, n6))) {
                        n2 = Math.min(n6 + 1, n);
                        continue;
                    }
                    n2 = n3 + 1;
                    continue;
                }
                string3 = string.substring(n2, n3).replace('/', '.');
                stringBuilder.append(string3);
                n2 = n3 + 1;
                continue;
            }
            stringBuilder.append(string, n2, n3);
            n2 = n3 + 1;
        }
        return stringBuilder.toString();
    }

    public static String removeLambdaIds(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = -1;
            int n5 = -1;
            for (n3 = n2; n3 < n; ++n3) {
                if (!Character.isDigit(string.charAt(n3))) continue;
                n5 = n3;
                break;
            }
            if (n5 == -1) {
                return n2 == 0 ? string : stringBuilder.append(string.substring(n2)).toString();
            }
            for (n3 = n5 + 1; n3 < n; ++n3) {
                if (Character.isDigit(string.charAt(n3))) continue;
                n4 = n3;
                break;
            }
            if (n5 >= 1 && string.charAt(n5 - 1) == '.' || n5 >= 1 && string.charAt(n5 - 1) == '$' || n5 >= 2 && string.charAt(n5 - 2) == '-' && string.charAt(n5 - 1) == '-' || n5 >= 2 && string.charAt(n5 - 2) == '_' && string.charAt(n5 - 1) == '_' || n5 >= 4 && string.charAt(n5 - 4) == 'e' && string.charAt(n5 - 3) == 'v' && string.charAt(n5 - 2) == 'a' && string.charAt(n5 - 1) == 'l') {
                stringBuilder.append(string.substring(n2, n5));
                if (n4 > -1) {
                    n2 = n4;
                    continue;
                }
                return stringBuilder.toString();
            }
            if (n4 <= -1) break;
            stringBuilder.append(string.substring(n2, n4));
            n2 = n4;
        }
        return n2 == 0 ? string : stringBuilder.append(string.substring(n2)).toString();
    }
}

