# TCC Ring Jetty Adapter


TCC Ring Jetty Adapter is a Clojure library that builds on top of [Ring Jetty Adapter] (https://github.com/ring-clojure/ring/tree/master/ring-jetty-adapter). Ring Jetty Adapter supports Jetty 7. This project adds support for Jetty 9.1 while still retaining support for Jetty 7. 

## Why Jetty 9 ?
Jetty-9 contains a heavily refactored IO layer which should make it easier to support low latency traffic. Jetty-9 has been rearchitected from the IO layer up to directly support the separation of wire protocol from semantic, so it is now possible to support HTTP over HTTP, HTTP over SPDY, Websocket over SPDY, multiplexing etc with all protocols being first class citizens.

### Jetty 9 Dependencies
Jetty-9 is servlet-api 3.0 and Jetty-9 requires java 1.7. SPDY is one of the really big deals about jetty-9 and SPDY requires java 1.7.

## Backwards Compatibility for Jetty 7
Given the fact that Jetty 9 requires Java 1.7 and we obviously do not want to force a java update on every one, TCC Ring Jetty Adapter used [leiningen profiles] (https://github.com/technomancy/leiningen/blob/master/doc/PROFILES.md) in combination with [leiningen classifiers] (https://github.com/technomancy/leiningen/blob/master/sample.project.clj) to support creation of artifacts that support both Jetty 7 and Jetty 9.

## Installation
TCC Ring Jetty Adapter builds two jars, namely ring-jetty-adapter-0.0.1.jar and ring-jetty-adapter-0.0.1-jetty9.jar. Due to some limitations on how dependencies are described in pom.xml that leiningen generates across various profiles, we cannot automatically call out jetty 7 jar as a dependency on ring-jetty-adapter-0.0.1.jar and jetty 9 jar on ring-jetty-adapter-0.0.1-jetty9.jar. Therefore, we require the users of com.climate/ring-jetty-adapter to also explicitly include appropriate versions of org.eclipse.jetty/jetty-server as one of the dependencies as shown below.

For Jetty 7 version use:

    [org.eclipse.jetty/jetty-server "7.6.8.v20121106"]
    [com.climate/tcc-ring-jetty-adapter "0.0.1"]

For Jetty 9 version use:
    
    [org.eclipse.jetty/jetty-server "9.1.0.M0"]
    [com.climate/tcc-ring-jetty-adapter "0.0.1" :classifier "jetty9"]

## Ring Community

* [Google group](http://groups.google.com/group/ring-clojure)

## Thanks

This project borrows is built on top of Clojure Ring project. Many thanks to those teams.

## License

Copyright © 2014 The Climate Corporation and released under an MIT license.
