/*
 * Decompiled with CFR 0.152.
 */
package com.climate.boomhauer;

import java.util.Calendar;
import java.util.Date;

public final class AlexaDateUtil {
    private static final int MORNING_THRESHOLD = 12;
    private static final int AFTERNOON_THRESHOLD = 17;
    private static final int EVENING_THRESHOLD = 20;
    private static final int MIDNIGHT_HOUR = 12;
    private static final int MINUTE_TWO_DIGIT_THRESHOLD = 10;
    private static final String[] DAYS_OF_MONTH = new String[]{"1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th", "11th", "12th", "13th", "14th", "15th", "16th", "17th", "18th", "19th", "20th", "21st", "22nd", "23rd", "24th", "25th", "26th", "27th", "28th", "29th", "30th", "31st"};
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS_OF_WEEK = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    private AlexaDateUtil() {
    }

    public static String getFormattedDate(Date date, boolean bl) {
        Date date2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        if (calendar.get(1) == calendar2.get(1)) {
            return DAYS_OF_WEEK[calendar2.get(7) - 1] + ' ' + MONTHS[calendar2.get(2)] + ' ' + DAYS_OF_MONTH[calendar2.get(5) - 1];
        }
        if (bl) {
            return DAYS_OF_WEEK[calendar2.get(7) - 1] + ' ' + MONTHS[calendar2.get(2)] + ' ' + DAYS_OF_MONTH[calendar2.get(5) - 1] + ' ' + calendar2.get(1);
        }
        return DAYS_OF_WEEK[calendar2.get(7) - 1] + ' ' + (calendar2.get(2) + 1) + '/' + calendar2.get(5) + '/' + calendar2.get(1);
    }

    public static String getFormattedTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        String string = n < 12 ? " in the morning" : (n < 17 ? " in the afternoon" : (n < 20 ? " in the evening" : " at night"));
        n = calendar.get(10);
        n = n == 0 ? 12 : n;
        String string2 = n2 < 10 ? "0" + Integer.toString(n2) : Integer.toString(n2);
        String string3 = Integer.toString(n) + ":" + string2 + string;
        return string3;
    }

    public static String getFormattedTimeAmPm(Date date) {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        String string = n >= 12 ? "pm" : "am";
        n = calendar.get(10);
        n = n == 0 ? 12 : n;
        String string2 = n2 < 10 ? "0" + Integer.toString(n2) : Integer.toString(n2);
        String string3 = Integer.toString(n) + ":" + string2 + " " + string;
        return string3;
    }
}

