(defproject com.chetmancini/schema-transform "0.0.1-SNAPSHOT"
  :description "Schema Transform is library for changing data specifications from one format to another to help build complex polyglot data systems."
  :url "https://github.com/chetmancini/schema-transform"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:name "git"
        :url  "https://github.com/chetmancini/schema-transform"}
  :signing {:gpg-key "chet@keybase.io"}
  :deploy-repositories [["clojars" {:creds :gpg}]]
  :dependencies [[cheshire "5.5.0"]
                 [prismatic/schema "1.0.0"]
                 [org.clojure/clojure "1.7.0"]
                 [camel-snake-kebab "0.3.2"]]
  :profiles {:uberjar {:aot :all}}
  :source-paths ["src"]
  :resource-paths ["resources"]
  :test-paths ["test"]
  :pom-addition [:developers [:developer
                              [:name "Chet Mancini"]
                              [:url "http://chetmancini.com"]
                              [:email "chetmancini@gmail.com"]
                              [:timezone "-5"]]])