(ns cemerick.pprng
  (:require [                          cljs.core :as lang]
                   math.seedrandom)
                                  
  (:refer-clojure :exclude (double float int long boolean)))

(defprotocol IRandom
  (-seed [this])
  (-next-double [this])
  (-next-float [this])
  (-next-int [this] [this limit])
  (-next-long [this])
  (-next-boolean [this]))

     
                                          
         
                     
                                         
                                       
                                   
                                               
                                     
                                            

     
                        
        
               
                                     
                                                                                            
                                                                                                      
                                          
                                        
            
                            
                                         
                                      
                                             

      
(defn- between
  [random low high]
  (+ low (* (random) (- high low))))

      
(defrecord SeededRandom [seed random-double]
  IRandom
  (-seed [this] seed)
  (-next-double [this] (random-double))
  (-next-float [this] (between random-double 1.4E-45 3.4028235E38))
  ; imprecise, but should be reliably so
  (-next-int [this] (lang/long (between random-double -2147483648 2147483647)))
  (-next-int [this limit] (lang/long (between random-double 0 limit)))
  (-next-long [this] (lang/long (between random-double -9007199254740992 9007199254740992)))
  (-next-boolean [this] (zero? (Math/floor (* 2 (random-double))))))

(defn rng
  "Returns a new random number generator seeded with [seed] that satisfies the
  `IRandom` protocol."
  ; TODO apply the same transformation to current time as j.u.Random does to
  ; obtain "a value very likely to be distinct from any other invocation" of
  ; this fn
  ([] (rng (.getTime                                (js/Date.))))
  ([seed]
          (Math/seedrandom seed)
   (SeededRandom. seed
                                      
                  ; seedrandom bashes out Math/random; capture it so
                  ; later `rng` invocations won't mess with existing RNGs' state
                         (do (Math/seedrandom seed)
                             Math/random))))

(defn seed
  "Returns the seed used to create the given RNG."
  [rng]
  (-seed rng))

(defn double
  "Returns the next double value from the given RNG."
  [rng]
  (-next-double rng))

(defn float
  "Returns the next float value from the given RNG."
  [rng]
  (-next-float rng))

(defn int
  "Returns the next int value from the given RNG.  If supplied a [limit] argument, the range of the returned int will be [0,limit)."
  ([rng] (-next-int rng))
  ([rng limit] (-next-int rng limit)))

(defn long
  "Returns the next long value from the given RNG."
  [rng]
  (-next-long rng))

(defn boolean
  "Returns the next boolean value from the given RNG."
  [rng]
  (-next-boolean rng))


;;;;;;;;;;;; This file autogenerated from src/cljx/cemerick/pprng.cljx
