(ns simple-check.properties
  (:require [simple-check.generators :as gen]))

;; NOTES:
;; The fields that should be returned from each test
;; run:
;;
;; pass?: boolean or nil (nil implies test was discarded)
;; expect: boolean or (maybe?) exception
;; values: the realized values during this test
;;
;;
;; These fields could be returned:
;;
;; interrupted?
;; stamp: haskell QC nomenclature for stats/values collected
;; callbacks: maybe this is where printing/clojure.test stuff goes?

(defn- apply-gen
  [function]
  (fn [args-rose]
    (gen/gen-pure
      (gen/rose-fmap
       (fn [args] (let [result (try (apply function args)
                                    (catch                        js/Error t t))]
                     {:result result
                      :function function
                      :args args}))
       args-rose))))

(defn for-all*
  "Creates a property (properties are also generators). A property
  is a generator that generates the result of applying the function
  under test with the realized arguments. Once realized, the arguments
  will be applied to `function` with `apply`.

  Example:

  (for-all* [gen/int gen/int] (fn [a b] (>= (+ a b) a)))
  "
  [args function]
  (gen/gen-bind (apply gen/tuple args)
                (apply-gen function)))

(defn- binding-vars
  [bindings]
  (map first (partition 2 bindings)))

(defn- binding-gens
  [bindings]
  (map second (partition 2 bindings)))

                 
                                                                    
                                                                     
                                    

          

                     
                      
                   
   
                   
            
                                   
                                    
                



;;;;;;;;;;;; This file autogenerated from src/cljx/simple_check/properties.cljx
