/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentVector;
import clojure.lang.ASeq;
import clojure.lang.ArrayChunk;
import clojure.lang.Counted;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientVector;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentVector
extends APersistentVector
implements IObj,
IEditableCollection {
    static final AtomicReference<Thread> NOEDIT = new AtomicReference<Object>(null);
    static final Node EMPTY_NODE = new Node(NOEDIT, new Object[32]);
    final int cnt;
    final int shift;
    final Node root;
    final Object[] tail;
    final IPersistentMap _meta;
    public static final PersistentVector EMPTY = new PersistentVector(0, 5, EMPTY_NODE, new Object[0]);

    public static PersistentVector create(ISeq items) {
        TransientVector ret = EMPTY.asTransient();
        while (items != null) {
            ret = ret.conj(items.first());
            items = items.next();
        }
        return ret.persistent();
    }

    public static PersistentVector create(List items) {
        TransientVector ret = EMPTY.asTransient();
        for (Object item : items) {
            ret = ret.conj(item);
        }
        return ret.persistent();
    }

    public static PersistentVector create(Object ... items) {
        TransientVector ret = EMPTY.asTransient();
        for (Object item : items) {
            ret = ret.conj(item);
        }
        return ret.persistent();
    }

    PersistentVector(int cnt, int shift, Node root, Object[] tail) {
        this._meta = null;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    PersistentVector(IPersistentMap meta, int cnt, int shift, Node root, Object[] tail) {
        this._meta = meta;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    @Override
    public TransientVector asTransient() {
        return new TransientVector(this);
    }

    final int tailoff() {
        if (this.cnt < 32) {
            return 0;
        }
        return this.cnt - 1 >>> 5 << 5;
    }

    public Object[] arrayFor(int i) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                return this.tail;
            }
            Node node = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                node = (Node)node.array[i >>> level & 0x1F];
            }
            return node.array;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object nth(int i) {
        Object[] node = this.arrayFor(i);
        return node[i & 0x1F];
    }

    @Override
    public Object nth(int i, Object notFound) {
        if (i >= 0 && i < this.cnt) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public PersistentVector assocN(int i, Object val) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val;
                return new PersistentVector(this.meta(), this.cnt, this.shift, this.root, newTail);
            }
            return new PersistentVector(this.meta(), this.cnt, this.shift, PersistentVector.doAssoc(this.shift, this.root, i, val), this.tail);
        }
        if (i == this.cnt) {
            return this.cons(val);
        }
        throw new IndexOutOfBoundsException();
    }

    private static Node doAssoc(int level, Node node, int i, Object val) {
        Node ret = new Node(node.edit, (Object[])node.array.clone());
        if (level == 0) {
            ret.array[i & 0x1F] = val;
        } else {
            int subidx = i >>> level & 0x1F;
            ret.array[subidx] = PersistentVector.doAssoc(level - 5, (Node)node.array[subidx], i, val);
        }
        return ret;
    }

    @Override
    public int count() {
        return this.cnt;
    }

    @Override
    public PersistentVector withMeta(IPersistentMap meta) {
        return new PersistentVector(meta, this.cnt, this.shift, this.root, this.tail);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public PersistentVector cons(Object val) {
        Node newroot;
        int i = this.cnt;
        if (this.cnt - this.tailoff() < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val;
            return new PersistentVector(this.meta(), this.cnt + 1, this.shift, this.root, newTail);
        }
        Node tailnode = new Node(this.root.edit, this.tail);
        int newshift = this.shift;
        if (this.cnt >>> 5 > 1 << this.shift) {
            newroot = new Node(this.root.edit);
            newroot.array[0] = this.root;
            newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
            newshift += 5;
        } else {
            newroot = this.pushTail(this.shift, this.root, tailnode);
        }
        return new PersistentVector(this.meta(), this.cnt + 1, newshift, newroot, new Object[]{val});
    }

    private Node pushTail(int level, Node parent, Node tailnode) {
        Node child;
        int subidx = this.cnt - 1 >>> level & 0x1F;
        Node ret = new Node(parent.edit, (Object[])parent.array.clone());
        Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
        ret.array[subidx] = nodeToInsert;
        return ret;
    }

    private static Node newPath(AtomicReference<Thread> edit, int level, Node node) {
        if (level == 0) {
            return node;
        }
        Node ret = new Node(edit);
        ret.array[0] = PersistentVector.newPath(edit, level - 5, node);
        return ret;
    }

    public IChunkedSeq chunkedSeq() {
        if (this.count() == 0) {
            return null;
        }
        return new ChunkedSeq(this, 0, 0);
    }

    @Override
    public ISeq seq() {
        return this.chunkedSeq();
    }

    Iterator rangedIterator(final int start, final int end) {
        return new Iterator(){
            int i;
            int base;
            Object[] array;
            {
                this.i = start;
                this.base = this.i - this.i % 32;
                this.array = start < PersistentVector.this.count() ? PersistentVector.this.arrayFor(this.i) : null;
            }

            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                if (this.i - this.base == 32) {
                    this.array = PersistentVector.this.arrayFor(this.i);
                    this.base += 32;
                }
                return this.array[this.i++ & 0x1F];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator iterator() {
        return this.rangedIterator(0, this.count());
    }

    public Object kvreduce(IFn f, Object init) {
        int step = 0;
        for (int i = 0; i < this.cnt; i += step) {
            Object[] array = this.arrayFor(i);
            for (int j = 0; j < array.length; ++j) {
                if (!RT.isReduced(init = f.invoke(init, j + i, array[j]))) continue;
                return ((IDeref)init).deref();
            }
            step = array.length;
        }
        return init;
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentVector pop() {
        if (this.cnt == 0) {
            throw new IllegalStateException("Can't pop empty vector");
        }
        if (this.cnt == 1) {
            return EMPTY.withMeta(this.meta());
        }
        if (this.cnt - this.tailoff() > 1) {
            Object[] newTail = new Object[this.tail.length - 1];
            System.arraycopy(this.tail, 0, newTail, 0, newTail.length);
            return new PersistentVector(this.meta(), this.cnt - 1, this.shift, this.root, newTail);
        }
        Object[] newtail = this.arrayFor(this.cnt - 2);
        Node newroot = this.popTail(this.shift, this.root);
        int newshift = this.shift;
        if (newroot == null) {
            newroot = EMPTY_NODE;
        }
        if (this.shift > 5 && newroot.array[1] == null) {
            newroot = (Node)newroot.array[0];
            newshift -= 5;
        }
        return new PersistentVector(this.meta(), this.cnt - 1, newshift, newroot, newtail);
    }

    private Node popTail(int level, Node node) {
        int subidx = this.cnt - 2 >>> level & 0x1F;
        if (level > 5) {
            Node newchild = this.popTail(level - 5, (Node)node.array[subidx]);
            if (newchild == null && subidx == 0) {
                return null;
            }
            Node ret = new Node(this.root.edit, (Object[])node.array.clone());
            ret.array[subidx] = newchild;
            return ret;
        }
        if (subidx == 0) {
            return null;
        }
        Node ret = new Node(this.root.edit, (Object[])node.array.clone());
        ret.array[subidx] = null;
        return ret;
    }

    static final class TransientVector
    extends AFn
    implements ITransientVector,
    Counted {
        int cnt;
        int shift;
        Node root;
        Object[] tail;

        TransientVector(int cnt, int shift, Node root, Object[] tail) {
            this.cnt = cnt;
            this.shift = shift;
            this.root = root;
            this.tail = tail;
        }

        TransientVector(PersistentVector v) {
            this(v.cnt, v.shift, TransientVector.editableRoot(v.root), TransientVector.editableTail(v.tail));
        }

        public int count() {
            this.ensureEditable();
            return this.cnt;
        }

        Node ensureEditable(Node node) {
            if (node.edit == this.root.edit) {
                return node;
            }
            return new Node(this.root.edit, (Object[])node.array.clone());
        }

        void ensureEditable() {
            Thread owner = this.root.edit.get();
            if (owner == Thread.currentThread()) {
                return;
            }
            if (owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }

        static Node editableRoot(Node node) {
            return new Node(new AtomicReference<Thread>(Thread.currentThread()), (Object[])node.array.clone());
        }

        public PersistentVector persistent() {
            this.ensureEditable();
            this.root.edit.set(null);
            Object[] trimmedTail = new Object[this.cnt - this.tailoff()];
            System.arraycopy(this.tail, 0, trimmedTail, 0, trimmedTail.length);
            return new PersistentVector(this.cnt, this.shift, this.root, trimmedTail);
        }

        static Object[] editableTail(Object[] tl) {
            Object[] ret = new Object[32];
            System.arraycopy(tl, 0, ret, 0, tl.length);
            return ret;
        }

        public TransientVector conj(Object val) {
            Node newroot;
            this.ensureEditable();
            int i = this.cnt++;
            if (i - this.tailoff() < 32) {
                this.tail[i & 0x1F] = val;
                return this;
            }
            Node tailnode = new Node(this.root.edit, this.tail);
            this.tail = new Object[32];
            this.tail[0] = val;
            int newshift = this.shift;
            if (this.cnt >>> 5 > 1 << this.shift) {
                newroot = new Node(this.root.edit);
                newroot.array[0] = this.root;
                newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
                newshift += 5;
            } else {
                newroot = this.pushTail(this.shift, this.root, tailnode);
            }
            this.root = newroot;
            this.shift = newshift;
            ++this.cnt;
            return this;
        }

        private Node pushTail(int level, Node parent, Node tailnode) {
            Node child;
            parent = this.ensureEditable(parent);
            int subidx = this.cnt - 1 >>> level & 0x1F;
            Node ret = parent;
            Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
            ret.array[subidx] = nodeToInsert;
            return ret;
        }

        private final int tailoff() {
            if (this.cnt < 32) {
                return 0;
            }
            return this.cnt - 1 >>> 5 << 5;
        }

        private Object[] arrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node = (Node)node.array[i >>> level & 0x1F];
                }
                return node.array;
            }
            throw new IndexOutOfBoundsException();
        }

        private Object[] editableArrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node = this.ensureEditable((Node)node.array[i >>> level & 0x1F]);
                }
                return node.array;
            }
            throw new IndexOutOfBoundsException();
        }

        public Object valAt(Object key) {
            return this.valAt(key, null);
        }

        public Object valAt(Object key, Object notFound) {
            int i;
            this.ensureEditable();
            if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.cnt) {
                return this.nth(i);
            }
            return notFound;
        }

        public Object invoke(Object arg1) {
            if (Util.isInteger(arg1)) {
                return this.nth(((Number)arg1).intValue());
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        public Object nth(int i) {
            this.ensureEditable();
            Object[] node = this.arrayFor(i);
            return node[i & 0x1F];
        }

        public Object nth(int i, Object notFound) {
            if (i >= 0 && i < this.count()) {
                return this.nth(i);
            }
            return notFound;
        }

        public TransientVector assocN(int i, Object val) {
            this.ensureEditable();
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    this.tail[i & 0x1F] = val;
                    return this;
                }
                this.root = this.doAssoc(this.shift, this.root, i, val);
                return this;
            }
            if (i == this.cnt) {
                return this.conj(val);
            }
            throw new IndexOutOfBoundsException();
        }

        public TransientVector assoc(Object key, Object val) {
            if (Util.isInteger(key)) {
                int i = ((Number)key).intValue();
                return this.assocN(i, val);
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        private Node doAssoc(int level, Node node, int i, Object val) {
            Node ret = node = this.ensureEditable(node);
            if (level == 0) {
                ret.array[i & 0x1F] = val;
            } else {
                int subidx = i >>> level & 0x1F;
                ret.array[subidx] = this.doAssoc(level - 5, (Node)node.array[subidx], i, val);
            }
            return ret;
        }

        public TransientVector pop() {
            this.ensureEditable();
            if (this.cnt == 0) {
                throw new IllegalStateException("Can't pop empty vector");
            }
            if (this.cnt == 1) {
                this.cnt = 0;
                return this;
            }
            int i = this.cnt - 1;
            if ((i & 0x1F) > 0) {
                --this.cnt;
                return this;
            }
            Object[] newtail = this.editableArrayFor(this.cnt - 2);
            Node newroot = this.popTail(this.shift, this.root);
            int newshift = this.shift;
            if (newroot == null) {
                newroot = new Node(this.root.edit);
            }
            if (this.shift > 5 && newroot.array[1] == null) {
                newroot = this.ensureEditable((Node)newroot.array[0]);
                newshift -= 5;
            }
            this.root = newroot;
            this.shift = newshift;
            --this.cnt;
            this.tail = newtail;
            return this;
        }

        private Node popTail(int level, Node node) {
            node = this.ensureEditable(node);
            int subidx = this.cnt - 2 >>> level & 0x1F;
            if (level > 5) {
                Node newchild = this.popTail(level - 5, (Node)node.array[subidx]);
                if (newchild == null && subidx == 0) {
                    return null;
                }
                Node ret = node;
                ret.array[subidx] = newchild;
                return ret;
            }
            if (subidx == 0) {
                return null;
            }
            Node ret = node;
            ret.array[subidx] = null;
            return ret;
        }
    }

    public static final class ChunkedSeq
    extends ASeq
    implements IChunkedSeq,
    Counted {
        public final PersistentVector vec;
        final Object[] node;
        final int i;
        public final int offset;

        public ChunkedSeq(PersistentVector vec, int i, int offset) {
            this.vec = vec;
            this.i = i;
            this.offset = offset;
            this.node = vec.arrayFor(i);
        }

        ChunkedSeq(IPersistentMap meta, PersistentVector vec, Object[] node, int i, int offset) {
            super(meta);
            this.vec = vec;
            this.node = node;
            this.i = i;
            this.offset = offset;
        }

        ChunkedSeq(PersistentVector vec, Object[] node, int i, int offset) {
            this.vec = vec;
            this.node = node;
            this.i = i;
            this.offset = offset;
        }

        public IChunk chunkedFirst() {
            return new ArrayChunk(this.node, this.offset);
        }

        public ISeq chunkedNext() {
            if (this.i + this.node.length < this.vec.cnt) {
                return new ChunkedSeq(this.vec, this.i + this.node.length, 0);
            }
            return null;
        }

        public ISeq chunkedMore() {
            ISeq s = this.chunkedNext();
            if (s == null) {
                return PersistentList.EMPTY;
            }
            return s;
        }

        public Obj withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new ChunkedSeq(meta, this.vec, this.node, this.i, this.offset);
        }

        public Object first() {
            return this.node[this.offset];
        }

        public ISeq next() {
            if (this.offset + 1 < this.node.length) {
                return new ChunkedSeq(this.vec, this.node, this.i, this.offset + 1);
            }
            return this.chunkedNext();
        }

        public int count() {
            return this.vec.cnt - (this.i + this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node
    implements Serializable {
        final transient AtomicReference<Thread> edit;
        final Object[] array;

        Node(AtomicReference<Thread> edit, Object[] array) {
            this.edit = edit;
            this.array = array;
        }

        Node(AtomicReference<Thread> edit) {
            this.edit = edit;
            this.array = new Object[32];
        }
    }
}

