--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = babble, pg_catalog;

DROP RULE no_duplicate_translations ON babble.translations;
DROP INDEX babble.ltrg_idx;
DROP INDEX babble.lsrc_idx;
DROP INDEX babble.lower_unique_idx;
DROP INDEX babble.lower_trg_idx;
DROP INDEX babble.lower_src_idx;
ALTER TABLE ONLY babble.translations DROP CONSTRAINT translations_pkey;
ALTER TABLE babble.translations ALTER COLUMN id DROP DEFAULT;
ALTER TABLE babble.cedict ALTER COLUMN id DROP DEFAULT;
DROP SEQUENCE babble.translations_id_seq;
DROP TABLE babble.translations;
DROP SEQUENCE babble.cedict_id_seq;
DROP TABLE babble.cedict;
DROP SCHEMA babble;
--
-- Name: babble; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA babble;


SET search_path = babble, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cedict; Type: TABLE; Schema: babble; Owner: -; Tablespace: 
--

CREATE TABLE cedict (
    id integer NOT NULL,
    simplified text NOT NULL,
    traditional text NOT NULL,
    pinyin text NOT NULL,
    english text NOT NULL
);


--
-- Name: cedict_id_seq; Type: SEQUENCE; Schema: babble; Owner: -
--

CREATE SEQUENCE cedict_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cedict_id_seq; Type: SEQUENCE OWNED BY; Schema: babble; Owner: -
--

ALTER SEQUENCE cedict_id_seq OWNED BY cedict.id;


--
-- Name: translations; Type: TABLE; Schema: babble; Owner: -; Tablespace: 
--

CREATE TABLE translations (
    id bigint NOT NULL,
    src text NOT NULL,
    trg text,
    lsrc text,
    ltrg text NOT NULL,
    created_at timestamp with time zone DEFAULT now()
);


--
-- Name: translations_id_seq; Type: SEQUENCE; Schema: babble; Owner: -
--

CREATE SEQUENCE translations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: translations_id_seq; Type: SEQUENCE OWNED BY; Schema: babble; Owner: -
--

ALTER SEQUENCE translations_id_seq OWNED BY translations.id;


--
-- Name: id; Type: DEFAULT; Schema: babble; Owner: -
--

ALTER TABLE ONLY cedict ALTER COLUMN id SET DEFAULT nextval('cedict_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: babble; Owner: -
--

ALTER TABLE ONLY translations ALTER COLUMN id SET DEFAULT nextval('translations_id_seq'::regclass);


--
-- Name: translations_pkey; Type: CONSTRAINT; Schema: babble; Owner: -; Tablespace: 
--

ALTER TABLE ONLY translations
    ADD CONSTRAINT translations_pkey PRIMARY KEY (id);


--
-- Name: lower_src_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lower_src_idx ON translations USING btree (lower(src) text_pattern_ops);


--
-- Name: lower_trg_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lower_trg_idx ON translations USING btree (lower(trg) text_pattern_ops);


--
-- Name: lower_unique_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX lower_unique_idx ON translations USING btree (lower(src) text_pattern_ops, lsrc, ltrg);


--
-- Name: lsrc_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lsrc_idx ON translations USING btree (lsrc);


--
-- Name: ltrg_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX ltrg_idx ON translations USING btree (ltrg);


--
-- Name: no_duplicate_translations; Type: RULE; Schema: babble; Owner: -
--

CREATE RULE no_duplicate_translations AS
    ON INSERT TO translations
   WHERE (EXISTS ( SELECT 1
           FROM translations
          WHERE (((translations.lsrc = new.lsrc) AND (translations.ltrg = new.ltrg)) AND (lower(translations.src) = lower(new.src))))) DO INSTEAD NOTHING;


--
-- PostgreSQL database dump complete
--

