(ns com.brunobonacci.reservoir.algorithms)

;;
;; Good article with various algorithms implemented.
;; https://richardstartin.github.io/posts/reservoir-sampling
;;

;; map and update
(defn add-to-reservoir
  [{:keys [capacity n buffer] :as reservoir} item]
  (if (< (count buffer) capacity)
    (-> reservoir
      (update :n inc)
      (update :buffer conj item))
    (let [idx (rand-int (inc n))
          reservoir (update reservoir :n inc)]
      (if (< idx capacity)
        (update reservoir :buffer assoc idx item)
        reservoir))))


;; just vector
(defn add-to-reservoir3
  [[capacity n buffer :as reservoir] item]
  (if (< (count buffer) capacity)
    [capacity (inc n) (conj buffer item)]
    (let [idx (rand-int (inc n))]
      (if (< idx capacity)
        [capacity (inc n) (assoc buffer idx item)]
        [capacity (inc n) buffer]))))


(comment
  (reduce add-to-reservoir {:capacity 10 :n 0 :buffer []} (range 30))
  (reduce add-to-reservoir3 [10 0 []] (range 30))
  )
