(ns country-code-validator.core
  (:gen-class))


(def country-codes (atom #{}))

(defn load-data []
  ;; original file
  ;; https://web.archive.org/web/20161122071627/http://www.iso.org/iso/home/standards/country_codes/country_names_and_code_elements_txt-temp.htm
  ;;
  ;; Saved to resources 04-08-2019
  (println "Loading data")
  (let [data (-> "data-file.txt"
                 clojure.java.io/resource
                 clojure.java.io/input-stream
                 slurp (clojure.string/split #"\n")
                 rest)]
    (into #{} (map #(second (clojure.string/split % #";")) data))))

(defn is-valid [s]
  (if (empty? @country-codes) (reset! country-codes (load-data)))
  (@country-codes s))

(defn debug-print [s]
  (println (format "Is country code %s valid? %b" s (is-valid s))))

(defn -main [& args]
  (debug-print "US")
  (debug-print "XX"))

