/*
 * Decompiled with CFR 0.152.
 */
package com.bot.strava.strava;

import com.bot.strava.enums.ActivityType;
import com.bot.strava.strava.MetaAthlete;
import com.bot.strava.strava.PolylineMap;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class StravaActivity {
    private long id;
    @JsonProperty(value="external_id")
    private String externalId;
    @JsonProperty(value="upload_id")
    private long uploadId;
    private MetaAthlete athlete;
    private String name;
    private float distance;
    @JsonProperty(value="moving_time")
    private int movingTime;
    @JsonProperty(value="elapsed_time")
    private int elapsedTime;
    @JsonProperty(value="total_elevation_gain")
    private float totalElevationGain;
    @JsonProperty(value="elev_high")
    private float elevHigh;
    @JsonProperty(value="elev_low")
    private float elevLow;
    private ActivityType type;
    @JsonProperty(value="start_date")
    private DateTime startDate;
    @JsonProperty(value="start_date_local")
    private DateTime startDateLocal;
    private String timezone;
    @JsonProperty(value="start_latlng")
    private ArrayList<Long> startLatlng;
    @JsonProperty(value="end_latlng")
    private ArrayList<Long> endLatlng;
    @JsonProperty(value="achievement_count")
    private int achievementCount;
    @JsonProperty(value="kudos_count")
    private int kudosCount;
    @JsonProperty(value="comment_count")
    private int commentCount;
    @JsonProperty(value="athlete_count")
    private int athleteCount;
    @JsonProperty(value="photo_count")
    private int photoCount;
    @JsonProperty(value="total_photo_count")
    private int totalPhotoCount;
    private PolylineMap map;
    private boolean trainer;
    private boolean commute;
    private boolean manual;
    @JsonProperty(value="private")
    private boolean privateActivity;
    private boolean flagged;
    @JsonProperty(value="workout_type")
    private int workoutType;
    @JsonProperty(value="upload_id_str")
    private String uploadIdStr;
    @JsonProperty(value="average_speed")
    private float averageSpeed;
    @JsonProperty(value="max_speed")
    private float maxSpeed;
    @JsonProperty(value="has_kudoed")
    private boolean hasKudoed;
    @JsonProperty(value="gear_id")
    private String gearId;
    private float kilojoules;
    @JsonProperty(value="average_watts")
    private float averageWatts;
    @JsonProperty(value="device_watts")
    private boolean deviceWatts;
    @JsonProperty(value="max_watts")
    private int maxWatts;
    @JsonProperty(value="weighted_average_watts")
    private int weightedAverageWatts;

    public static StravaActivityBuilder builder() {
        return new StravaActivityBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public long getUploadId() {
        return this.uploadId;
    }

    public MetaAthlete getAthlete() {
        return this.athlete;
    }

    public String getName() {
        return this.name;
    }

    public float getDistance() {
        return this.distance;
    }

    public int getMovingTime() {
        return this.movingTime;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public float getTotalElevationGain() {
        return this.totalElevationGain;
    }

    public float getElevHigh() {
        return this.elevHigh;
    }

    public float getElevLow() {
        return this.elevLow;
    }

    public ActivityType getType() {
        return this.type;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getStartDateLocal() {
        return this.startDateLocal;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ArrayList<Long> getStartLatlng() {
        return this.startLatlng;
    }

    public ArrayList<Long> getEndLatlng() {
        return this.endLatlng;
    }

    public int getAchievementCount() {
        return this.achievementCount;
    }

    public int getKudosCount() {
        return this.kudosCount;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public int getAthleteCount() {
        return this.athleteCount;
    }

    public int getPhotoCount() {
        return this.photoCount;
    }

    public int getTotalPhotoCount() {
        return this.totalPhotoCount;
    }

    public PolylineMap getMap() {
        return this.map;
    }

    public boolean isTrainer() {
        return this.trainer;
    }

    public boolean isCommute() {
        return this.commute;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isPrivateActivity() {
        return this.privateActivity;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public int getWorkoutType() {
        return this.workoutType;
    }

    public String getUploadIdStr() {
        return this.uploadIdStr;
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public boolean isHasKudoed() {
        return this.hasKudoed;
    }

    public String getGearId() {
        return this.gearId;
    }

    public float getKilojoules() {
        return this.kilojoules;
    }

    public float getAverageWatts() {
        return this.averageWatts;
    }

    public boolean isDeviceWatts() {
        return this.deviceWatts;
    }

    public int getMaxWatts() {
        return this.maxWatts;
    }

    public int getWeightedAverageWatts() {
        return this.weightedAverageWatts;
    }

    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="external_id")
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="upload_id")
    public void setUploadId(long uploadId) {
        this.uploadId = uploadId;
    }

    public void setAthlete(MetaAthlete athlete) {
        this.athlete = athlete;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    @JsonProperty(value="moving_time")
    public void setMovingTime(int movingTime) {
        this.movingTime = movingTime;
    }

    @JsonProperty(value="elapsed_time")
    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @JsonProperty(value="total_elevation_gain")
    public void setTotalElevationGain(float totalElevationGain) {
        this.totalElevationGain = totalElevationGain;
    }

    @JsonProperty(value="elev_high")
    public void setElevHigh(float elevHigh) {
        this.elevHigh = elevHigh;
    }

    @JsonProperty(value="elev_low")
    public void setElevLow(float elevLow) {
        this.elevLow = elevLow;
    }

    public void setType(ActivityType type) {
        this.type = type;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="start_date_local")
    public void setStartDateLocal(DateTime startDateLocal) {
        this.startDateLocal = startDateLocal;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @JsonProperty(value="start_latlng")
    public void setStartLatlng(ArrayList<Long> startLatlng) {
        this.startLatlng = startLatlng;
    }

    @JsonProperty(value="end_latlng")
    public void setEndLatlng(ArrayList<Long> endLatlng) {
        this.endLatlng = endLatlng;
    }

    @JsonProperty(value="achievement_count")
    public void setAchievementCount(int achievementCount) {
        this.achievementCount = achievementCount;
    }

    @JsonProperty(value="kudos_count")
    public void setKudosCount(int kudosCount) {
        this.kudosCount = kudosCount;
    }

    @JsonProperty(value="comment_count")
    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    @JsonProperty(value="athlete_count")
    public void setAthleteCount(int athleteCount) {
        this.athleteCount = athleteCount;
    }

    @JsonProperty(value="photo_count")
    public void setPhotoCount(int photoCount) {
        this.photoCount = photoCount;
    }

    @JsonProperty(value="total_photo_count")
    public void setTotalPhotoCount(int totalPhotoCount) {
        this.totalPhotoCount = totalPhotoCount;
    }

    public void setMap(PolylineMap map) {
        this.map = map;
    }

    public void setTrainer(boolean trainer) {
        this.trainer = trainer;
    }

    public void setCommute(boolean commute) {
        this.commute = commute;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    @JsonProperty(value="private")
    public void setPrivateActivity(boolean privateActivity) {
        this.privateActivity = privateActivity;
    }

    public void setFlagged(boolean flagged) {
        this.flagged = flagged;
    }

    @JsonProperty(value="workout_type")
    public void setWorkoutType(int workoutType) {
        this.workoutType = workoutType;
    }

    @JsonProperty(value="upload_id_str")
    public void setUploadIdStr(String uploadIdStr) {
        this.uploadIdStr = uploadIdStr;
    }

    @JsonProperty(value="average_speed")
    public void setAverageSpeed(float averageSpeed) {
        this.averageSpeed = averageSpeed;
    }

    @JsonProperty(value="max_speed")
    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    @JsonProperty(value="has_kudoed")
    public void setHasKudoed(boolean hasKudoed) {
        this.hasKudoed = hasKudoed;
    }

    @JsonProperty(value="gear_id")
    public void setGearId(String gearId) {
        this.gearId = gearId;
    }

    public void setKilojoules(float kilojoules) {
        this.kilojoules = kilojoules;
    }

    @JsonProperty(value="average_watts")
    public void setAverageWatts(float averageWatts) {
        this.averageWatts = averageWatts;
    }

    @JsonProperty(value="device_watts")
    public void setDeviceWatts(boolean deviceWatts) {
        this.deviceWatts = deviceWatts;
    }

    @JsonProperty(value="max_watts")
    public void setMaxWatts(int maxWatts) {
        this.maxWatts = maxWatts;
    }

    @JsonProperty(value="weighted_average_watts")
    public void setWeightedAverageWatts(int weightedAverageWatts) {
        this.weightedAverageWatts = weightedAverageWatts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StravaActivity)) {
            return false;
        }
        StravaActivity other = (StravaActivity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.getUploadId() != other.getUploadId()) {
            return false;
        }
        MetaAthlete this$athlete = this.getAthlete();
        MetaAthlete other$athlete = other.getAthlete();
        if (this$athlete == null ? other$athlete != null : !((Object)this$athlete).equals(other$athlete)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (Float.compare(this.getDistance(), other.getDistance()) != 0) {
            return false;
        }
        if (this.getMovingTime() != other.getMovingTime()) {
            return false;
        }
        if (this.getElapsedTime() != other.getElapsedTime()) {
            return false;
        }
        if (Float.compare(this.getTotalElevationGain(), other.getTotalElevationGain()) != 0) {
            return false;
        }
        if (Float.compare(this.getElevHigh(), other.getElevHigh()) != 0) {
            return false;
        }
        if (Float.compare(this.getElevLow(), other.getElevLow()) != 0) {
            return false;
        }
        ActivityType this$type = this.getType();
        ActivityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DateTime this$startDate = this.getStartDate();
        DateTime other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        DateTime this$startDateLocal = this.getStartDateLocal();
        DateTime other$startDateLocal = other.getStartDateLocal();
        if (this$startDateLocal == null ? other$startDateLocal != null : !this$startDateLocal.equals(other$startDateLocal)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        ArrayList<Long> this$startLatlng = this.getStartLatlng();
        ArrayList<Long> other$startLatlng = other.getStartLatlng();
        if (this$startLatlng == null ? other$startLatlng != null : !((Object)this$startLatlng).equals(other$startLatlng)) {
            return false;
        }
        ArrayList<Long> this$endLatlng = this.getEndLatlng();
        ArrayList<Long> other$endLatlng = other.getEndLatlng();
        if (this$endLatlng == null ? other$endLatlng != null : !((Object)this$endLatlng).equals(other$endLatlng)) {
            return false;
        }
        if (this.getAchievementCount() != other.getAchievementCount()) {
            return false;
        }
        if (this.getKudosCount() != other.getKudosCount()) {
            return false;
        }
        if (this.getCommentCount() != other.getCommentCount()) {
            return false;
        }
        if (this.getAthleteCount() != other.getAthleteCount()) {
            return false;
        }
        if (this.getPhotoCount() != other.getPhotoCount()) {
            return false;
        }
        if (this.getTotalPhotoCount() != other.getTotalPhotoCount()) {
            return false;
        }
        PolylineMap this$map = this.getMap();
        PolylineMap other$map = other.getMap();
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        if (this.isTrainer() != other.isTrainer()) {
            return false;
        }
        if (this.isCommute() != other.isCommute()) {
            return false;
        }
        if (this.isManual() != other.isManual()) {
            return false;
        }
        if (this.isPrivateActivity() != other.isPrivateActivity()) {
            return false;
        }
        if (this.isFlagged() != other.isFlagged()) {
            return false;
        }
        if (this.getWorkoutType() != other.getWorkoutType()) {
            return false;
        }
        String this$uploadIdStr = this.getUploadIdStr();
        String other$uploadIdStr = other.getUploadIdStr();
        if (this$uploadIdStr == null ? other$uploadIdStr != null : !this$uploadIdStr.equals(other$uploadIdStr)) {
            return false;
        }
        if (Float.compare(this.getAverageSpeed(), other.getAverageSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getMaxSpeed(), other.getMaxSpeed()) != 0) {
            return false;
        }
        if (this.isHasKudoed() != other.isHasKudoed()) {
            return false;
        }
        String this$gearId = this.getGearId();
        String other$gearId = other.getGearId();
        if (this$gearId == null ? other$gearId != null : !this$gearId.equals(other$gearId)) {
            return false;
        }
        if (Float.compare(this.getKilojoules(), other.getKilojoules()) != 0) {
            return false;
        }
        if (Float.compare(this.getAverageWatts(), other.getAverageWatts()) != 0) {
            return false;
        }
        if (this.isDeviceWatts() != other.isDeviceWatts()) {
            return false;
        }
        if (this.getMaxWatts() != other.getMaxWatts()) {
            return false;
        }
        return this.getWeightedAverageWatts() == other.getWeightedAverageWatts();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StravaActivity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        long $uploadId = this.getUploadId();
        result = result * 59 + (int)($uploadId >>> 32 ^ $uploadId);
        MetaAthlete $athlete = this.getAthlete();
        result = result * 59 + ($athlete == null ? 43 : ((Object)$athlete).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getDistance());
        result = result * 59 + this.getMovingTime();
        result = result * 59 + this.getElapsedTime();
        result = result * 59 + Float.floatToIntBits(this.getTotalElevationGain());
        result = result * 59 + Float.floatToIntBits(this.getElevHigh());
        result = result * 59 + Float.floatToIntBits(this.getElevLow());
        ActivityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DateTime $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        DateTime $startDateLocal = this.getStartDateLocal();
        result = result * 59 + ($startDateLocal == null ? 43 : $startDateLocal.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        ArrayList<Long> $startLatlng = this.getStartLatlng();
        result = result * 59 + ($startLatlng == null ? 43 : ((Object)$startLatlng).hashCode());
        ArrayList<Long> $endLatlng = this.getEndLatlng();
        result = result * 59 + ($endLatlng == null ? 43 : ((Object)$endLatlng).hashCode());
        result = result * 59 + this.getAchievementCount();
        result = result * 59 + this.getKudosCount();
        result = result * 59 + this.getCommentCount();
        result = result * 59 + this.getAthleteCount();
        result = result * 59 + this.getPhotoCount();
        result = result * 59 + this.getTotalPhotoCount();
        PolylineMap $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        result = result * 59 + (this.isTrainer() ? 79 : 97);
        result = result * 59 + (this.isCommute() ? 79 : 97);
        result = result * 59 + (this.isManual() ? 79 : 97);
        result = result * 59 + (this.isPrivateActivity() ? 79 : 97);
        result = result * 59 + (this.isFlagged() ? 79 : 97);
        result = result * 59 + this.getWorkoutType();
        String $uploadIdStr = this.getUploadIdStr();
        result = result * 59 + ($uploadIdStr == null ? 43 : $uploadIdStr.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getAverageSpeed());
        result = result * 59 + Float.floatToIntBits(this.getMaxSpeed());
        result = result * 59 + (this.isHasKudoed() ? 79 : 97);
        String $gearId = this.getGearId();
        result = result * 59 + ($gearId == null ? 43 : $gearId.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getKilojoules());
        result = result * 59 + Float.floatToIntBits(this.getAverageWatts());
        result = result * 59 + (this.isDeviceWatts() ? 79 : 97);
        result = result * 59 + this.getMaxWatts();
        result = result * 59 + this.getWeightedAverageWatts();
        return result;
    }

    public String toString() {
        return "StravaActivity(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", uploadId=" + this.getUploadId() + ", athlete=" + this.getAthlete() + ", name=" + this.getName() + ", distance=" + this.getDistance() + ", movingTime=" + this.getMovingTime() + ", elapsedTime=" + this.getElapsedTime() + ", totalElevationGain=" + this.getTotalElevationGain() + ", elevHigh=" + this.getElevHigh() + ", elevLow=" + this.getElevLow() + ", type=" + (Object)((Object)this.getType()) + ", startDate=" + this.getStartDate() + ", startDateLocal=" + this.getStartDateLocal() + ", timezone=" + this.getTimezone() + ", startLatlng=" + this.getStartLatlng() + ", endLatlng=" + this.getEndLatlng() + ", achievementCount=" + this.getAchievementCount() + ", kudosCount=" + this.getKudosCount() + ", commentCount=" + this.getCommentCount() + ", athleteCount=" + this.getAthleteCount() + ", photoCount=" + this.getPhotoCount() + ", totalPhotoCount=" + this.getTotalPhotoCount() + ", map=" + this.getMap() + ", trainer=" + this.isTrainer() + ", commute=" + this.isCommute() + ", manual=" + this.isManual() + ", privateActivity=" + this.isPrivateActivity() + ", flagged=" + this.isFlagged() + ", workoutType=" + this.getWorkoutType() + ", uploadIdStr=" + this.getUploadIdStr() + ", averageSpeed=" + this.getAverageSpeed() + ", maxSpeed=" + this.getMaxSpeed() + ", hasKudoed=" + this.isHasKudoed() + ", gearId=" + this.getGearId() + ", kilojoules=" + this.getKilojoules() + ", averageWatts=" + this.getAverageWatts() + ", deviceWatts=" + this.isDeviceWatts() + ", maxWatts=" + this.getMaxWatts() + ", weightedAverageWatts=" + this.getWeightedAverageWatts() + ")";
    }

    public StravaActivity(long id, String externalId, long uploadId, MetaAthlete athlete, String name, float distance, int movingTime, int elapsedTime, float totalElevationGain, float elevHigh, float elevLow, ActivityType type, DateTime startDate, DateTime startDateLocal, String timezone, ArrayList<Long> startLatlng, ArrayList<Long> endLatlng, int achievementCount, int kudosCount, int commentCount, int athleteCount, int photoCount, int totalPhotoCount, PolylineMap map, boolean trainer, boolean commute, boolean manual, boolean privateActivity, boolean flagged, int workoutType, String uploadIdStr, float averageSpeed, float maxSpeed, boolean hasKudoed, String gearId, float kilojoules, float averageWatts, boolean deviceWatts, int maxWatts, int weightedAverageWatts) {
        this.id = id;
        this.externalId = externalId;
        this.uploadId = uploadId;
        this.athlete = athlete;
        this.name = name;
        this.distance = distance;
        this.movingTime = movingTime;
        this.elapsedTime = elapsedTime;
        this.totalElevationGain = totalElevationGain;
        this.elevHigh = elevHigh;
        this.elevLow = elevLow;
        this.type = type;
        this.startDate = startDate;
        this.startDateLocal = startDateLocal;
        this.timezone = timezone;
        this.startLatlng = startLatlng;
        this.endLatlng = endLatlng;
        this.achievementCount = achievementCount;
        this.kudosCount = kudosCount;
        this.commentCount = commentCount;
        this.athleteCount = athleteCount;
        this.photoCount = photoCount;
        this.totalPhotoCount = totalPhotoCount;
        this.map = map;
        this.trainer = trainer;
        this.commute = commute;
        this.manual = manual;
        this.privateActivity = privateActivity;
        this.flagged = flagged;
        this.workoutType = workoutType;
        this.uploadIdStr = uploadIdStr;
        this.averageSpeed = averageSpeed;
        this.maxSpeed = maxSpeed;
        this.hasKudoed = hasKudoed;
        this.gearId = gearId;
        this.kilojoules = kilojoules;
        this.averageWatts = averageWatts;
        this.deviceWatts = deviceWatts;
        this.maxWatts = maxWatts;
        this.weightedAverageWatts = weightedAverageWatts;
    }

    public StravaActivity() {
    }

    public static class StravaActivityBuilder {
        private long id;
        private String externalId;
        private long uploadId;
        private MetaAthlete athlete;
        private String name;
        private float distance;
        private int movingTime;
        private int elapsedTime;
        private float totalElevationGain;
        private float elevHigh;
        private float elevLow;
        private ActivityType type;
        private DateTime startDate;
        private DateTime startDateLocal;
        private String timezone;
        private ArrayList<Long> startLatlng;
        private ArrayList<Long> endLatlng;
        private int achievementCount;
        private int kudosCount;
        private int commentCount;
        private int athleteCount;
        private int photoCount;
        private int totalPhotoCount;
        private PolylineMap map;
        private boolean trainer;
        private boolean commute;
        private boolean manual;
        private boolean privateActivity;
        private boolean flagged;
        private int workoutType;
        private String uploadIdStr;
        private float averageSpeed;
        private float maxSpeed;
        private boolean hasKudoed;
        private String gearId;
        private float kilojoules;
        private float averageWatts;
        private boolean deviceWatts;
        private int maxWatts;
        private int weightedAverageWatts;

        StravaActivityBuilder() {
        }

        public StravaActivityBuilder id(long id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="external_id")
        public StravaActivityBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @JsonProperty(value="upload_id")
        public StravaActivityBuilder uploadId(long uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public StravaActivityBuilder athlete(MetaAthlete athlete) {
            this.athlete = athlete;
            return this;
        }

        public StravaActivityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StravaActivityBuilder distance(float distance) {
            this.distance = distance;
            return this;
        }

        @JsonProperty(value="moving_time")
        public StravaActivityBuilder movingTime(int movingTime) {
            this.movingTime = movingTime;
            return this;
        }

        @JsonProperty(value="elapsed_time")
        public StravaActivityBuilder elapsedTime(int elapsedTime) {
            this.elapsedTime = elapsedTime;
            return this;
        }

        @JsonProperty(value="total_elevation_gain")
        public StravaActivityBuilder totalElevationGain(float totalElevationGain) {
            this.totalElevationGain = totalElevationGain;
            return this;
        }

        @JsonProperty(value="elev_high")
        public StravaActivityBuilder elevHigh(float elevHigh) {
            this.elevHigh = elevHigh;
            return this;
        }

        @JsonProperty(value="elev_low")
        public StravaActivityBuilder elevLow(float elevLow) {
            this.elevLow = elevLow;
            return this;
        }

        public StravaActivityBuilder type(ActivityType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="start_date")
        public StravaActivityBuilder startDate(DateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="start_date_local")
        public StravaActivityBuilder startDateLocal(DateTime startDateLocal) {
            this.startDateLocal = startDateLocal;
            return this;
        }

        public StravaActivityBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @JsonProperty(value="start_latlng")
        public StravaActivityBuilder startLatlng(ArrayList<Long> startLatlng) {
            this.startLatlng = startLatlng;
            return this;
        }

        @JsonProperty(value="end_latlng")
        public StravaActivityBuilder endLatlng(ArrayList<Long> endLatlng) {
            this.endLatlng = endLatlng;
            return this;
        }

        @JsonProperty(value="achievement_count")
        public StravaActivityBuilder achievementCount(int achievementCount) {
            this.achievementCount = achievementCount;
            return this;
        }

        @JsonProperty(value="kudos_count")
        public StravaActivityBuilder kudosCount(int kudosCount) {
            this.kudosCount = kudosCount;
            return this;
        }

        @JsonProperty(value="comment_count")
        public StravaActivityBuilder commentCount(int commentCount) {
            this.commentCount = commentCount;
            return this;
        }

        @JsonProperty(value="athlete_count")
        public StravaActivityBuilder athleteCount(int athleteCount) {
            this.athleteCount = athleteCount;
            return this;
        }

        @JsonProperty(value="photo_count")
        public StravaActivityBuilder photoCount(int photoCount) {
            this.photoCount = photoCount;
            return this;
        }

        @JsonProperty(value="total_photo_count")
        public StravaActivityBuilder totalPhotoCount(int totalPhotoCount) {
            this.totalPhotoCount = totalPhotoCount;
            return this;
        }

        public StravaActivityBuilder map(PolylineMap map) {
            this.map = map;
            return this;
        }

        public StravaActivityBuilder trainer(boolean trainer) {
            this.trainer = trainer;
            return this;
        }

        public StravaActivityBuilder commute(boolean commute) {
            this.commute = commute;
            return this;
        }

        public StravaActivityBuilder manual(boolean manual) {
            this.manual = manual;
            return this;
        }

        @JsonProperty(value="private")
        public StravaActivityBuilder privateActivity(boolean privateActivity) {
            this.privateActivity = privateActivity;
            return this;
        }

        public StravaActivityBuilder flagged(boolean flagged) {
            this.flagged = flagged;
            return this;
        }

        @JsonProperty(value="workout_type")
        public StravaActivityBuilder workoutType(int workoutType) {
            this.workoutType = workoutType;
            return this;
        }

        @JsonProperty(value="upload_id_str")
        public StravaActivityBuilder uploadIdStr(String uploadIdStr) {
            this.uploadIdStr = uploadIdStr;
            return this;
        }

        @JsonProperty(value="average_speed")
        public StravaActivityBuilder averageSpeed(float averageSpeed) {
            this.averageSpeed = averageSpeed;
            return this;
        }

        @JsonProperty(value="max_speed")
        public StravaActivityBuilder maxSpeed(float maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        @JsonProperty(value="has_kudoed")
        public StravaActivityBuilder hasKudoed(boolean hasKudoed) {
            this.hasKudoed = hasKudoed;
            return this;
        }

        @JsonProperty(value="gear_id")
        public StravaActivityBuilder gearId(String gearId) {
            this.gearId = gearId;
            return this;
        }

        public StravaActivityBuilder kilojoules(float kilojoules) {
            this.kilojoules = kilojoules;
            return this;
        }

        @JsonProperty(value="average_watts")
        public StravaActivityBuilder averageWatts(float averageWatts) {
            this.averageWatts = averageWatts;
            return this;
        }

        @JsonProperty(value="device_watts")
        public StravaActivityBuilder deviceWatts(boolean deviceWatts) {
            this.deviceWatts = deviceWatts;
            return this;
        }

        @JsonProperty(value="max_watts")
        public StravaActivityBuilder maxWatts(int maxWatts) {
            this.maxWatts = maxWatts;
            return this;
        }

        @JsonProperty(value="weighted_average_watts")
        public StravaActivityBuilder weightedAverageWatts(int weightedAverageWatts) {
            this.weightedAverageWatts = weightedAverageWatts;
            return this;
        }

        public StravaActivity build() {
            return new StravaActivity(this.id, this.externalId, this.uploadId, this.athlete, this.name, this.distance, this.movingTime, this.elapsedTime, this.totalElevationGain, this.elevHigh, this.elevLow, this.type, this.startDate, this.startDateLocal, this.timezone, this.startLatlng, this.endLatlng, this.achievementCount, this.kudosCount, this.commentCount, this.athleteCount, this.photoCount, this.totalPhotoCount, this.map, this.trainer, this.commute, this.manual, this.privateActivity, this.flagged, this.workoutType, this.uploadIdStr, this.averageSpeed, this.maxSpeed, this.hasKudoed, this.gearId, this.kilojoules, this.averageWatts, this.deviceWatts, this.maxWatts, this.weightedAverageWatts);
        }

        public String toString() {
            return "StravaActivity.StravaActivityBuilder(id=" + this.id + ", externalId=" + this.externalId + ", uploadId=" + this.uploadId + ", athlete=" + this.athlete + ", name=" + this.name + ", distance=" + this.distance + ", movingTime=" + this.movingTime + ", elapsedTime=" + this.elapsedTime + ", totalElevationGain=" + this.totalElevationGain + ", elevHigh=" + this.elevHigh + ", elevLow=" + this.elevLow + ", type=" + (Object)((Object)this.type) + ", startDate=" + this.startDate + ", startDateLocal=" + this.startDateLocal + ", timezone=" + this.timezone + ", startLatlng=" + this.startLatlng + ", endLatlng=" + this.endLatlng + ", achievementCount=" + this.achievementCount + ", kudosCount=" + this.kudosCount + ", commentCount=" + this.commentCount + ", athleteCount=" + this.athleteCount + ", photoCount=" + this.photoCount + ", totalPhotoCount=" + this.totalPhotoCount + ", map=" + this.map + ", trainer=" + this.trainer + ", commute=" + this.commute + ", manual=" + this.manual + ", privateActivity=" + this.privateActivity + ", flagged=" + this.flagged + ", workoutType=" + this.workoutType + ", uploadIdStr=" + this.uploadIdStr + ", averageSpeed=" + this.averageSpeed + ", maxSpeed=" + this.maxSpeed + ", hasKudoed=" + this.hasKudoed + ", gearId=" + this.gearId + ", kilojoules=" + this.kilojoules + ", averageWatts=" + this.averageWatts + ", deviceWatts=" + this.deviceWatts + ", maxWatts=" + this.maxWatts + ", weightedAverageWatts=" + this.weightedAverageWatts + ")";
        }
    }
}

