(defproject com.bizlogic/service-tools "0.0.2"
  :description "Service tools for bzilogic clojure projects."
  :url "http://github.com/johnbendi/service-tools"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.7.0-beta2"]
                 [org.clojure/core.async "0.1.346.0-17112a-alpha"
                  :exclusions [[org.clojure/clojurescript]]]
                 [io.pedestal/pedestal.service "0.4.0"]
                 [io.pedestal/pedestal.service-tools "0.4.0"]
                 [org.slf4j/slf4j-api "1.7.7"]
                 [ch.qos.logback/logback-classic "1.1.2"]
                 [com.cemerick/pomegranate "0.3.0"]
                 [clj-time "0.8.0"]
                 [danlentz/clj-uuid "0.1.6"]
                 [clojure-watch "0.1.10"]
                 [enlive "1.1.5"]
                 [clojurewerkz/quartzite "2.0.0"]
                 [amazonica "0.2.10"
                  :exclusions [joda-time
                               ;; com.amazonaws/aws-java-sdk
                               ;; com.amazonaws/amazon-kinesis-client
                               ]]
                 [com.datomic/datomic-pro "0.9.5206"
                  :exclusions [org.slf4j/slf4j-nop
                               org.slf4j/jcl-over-slf4j
                               org.slf4j/log4j-over-slf4j
                               org.slf4j/jul-to-slf4j joda-time
                               com.fasterxml.jackson.core/jackson-databind
                               com.fasterxml.jackson.core/jackson-annotations]]]
  :source-paths ["src"]
  :scm {:url "git@github.com:johnbendi/service-tools.git"}
  :pom-addition [:developers [:developer
                              [:name "John Chijioke"]
                              [:url "http://github.com/johnbendi"]
                              [:email "johnbendie@gmail.com"]
                              [:timezone "+1"]]]
  :target-path "target/%s/"
  :compile-path "%s/classes"

  :deploy-repositories
  [["releases" :clojars]])

(comment
  ["releases"
    {:url "https://oss.sonatype.org/service/local/staging/deploy/maven2/"
     :creds :gpg}
    "snapshots"
    {:url "https://oss.sonatype.org/content/repositories/snapshots/"
     :creds :gpg}])
