(defproject com.bizlogic/service-tools "0.0.1-SNAPSHOT"
  :description "Service tools for bzilogic clojure projects."
  :url "http://github.com/johnbendi/service-tools"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.6.0"]]
  :source-paths ["src"]
  :scm {:url "git@github.com:johnbendi/service-tools.git"}
  :pom-addition [:developers [:developer
                              [:name "John Chijioke"]
                              [:url "http://github.com/johnbendi"]
                              [:email "johnbendie@gmail.com"]
                              [:timezone "+1"]]]
  :target-path "target/%s/"
  :compile-path "%s/classes"

  :deploy-repositories
  [["releases" :clojars]])

(comment
  ["releases"
    {:url "https://oss.sonatype.org/service/local/staging/deploy/maven2/"
     :creds :gpg}
    "snapshots"
    {:url "https://oss.sonatype.org/content/repositories/snapshots/"
     :creds :gpg}])
