(ns bizlogic.tools.utils
  (:require [clojure.string :as str]
            [clojure.string :as string]
            [bizlogic.tools.log :as log]
            [clojure.java.io :as io]
            [datomic.api :as d :refer [db]])
  (:import (java.io File FileOutputStream BufferedOutputStream
             ByteArrayOutputStream)
           (java.util.zip ZipInputStream)
           (java.util.jar JarFile Manifest JarEntry JarOutputStream)
           (java.util.regex Pattern)))

(defn insert-at [n x coll]
  (vec (concat (take n coll) [x] (drop (inc n) coll))))

(defn- ensure-ends-with-sep [p]
  (if (.endsWith p File/separator) p (str p File/separator)))

(defn trim-left-right [coll]
  (map (fn [x]
         (-> (#(str/replace-first (str/reverse x) "-" ""))
             (#(str/replace-first (str/reverse %) "-" ""))))
       coll))

(def email-re #"\b[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}\b")

(defn ensure-dir
  "Ensures that a directory exists at the given path, throwing if one does not."
  [^String dir-path]
  (let [dir (java.io.File. dir-path)]
    (if-not (.exists dir)
      (throw (Exception. (format "Directory does not exist: %s" dir-path))))))

;; possibly make maniffest from project.clj or some other config
(defn jar [dir target & manifest]
  (let [zipinput (ZipInputStream. dir)
        file-output (io/file target)
        jar-output (-> file-output
                     (FileOutputStream.)
                     (BufferedOutputStream.)
                     (JarOutputStream. manifest))
        zip-entries (cond
                      )]))

(def tomcat-webapps "/opt/tomcat/tomcat7/base/webapps")

(defn deploy-tomcat [jarname])

;; datomic
(defn build-schema [ident type card & [doc unique index]]
  (merge {:db/id #db/id[:db.part/db]
          :db/ident ident
          :db/valueType (keyword (str "db.type/" (name type)))
          :db/cardinality (keyword (str "db.cardinality/" (name card)))}
    (if doc {:db/doc doc})
    (or (and unique {:db/unique (keyword (str "db.unique/" unique))})
      (or (and index {:db/index true}) nil))))
