# riberry

[![Build Status](https://github.com/zcaudate-xyz/riberry/actions/workflows/clojure.yml/badge.svg)](https://github.com/zcaudate-xyz/riberry/actions)
[![Clojars Project](https://img.shields.io/clojars/v/xyz.zcaudate/riberry.svg)](https://clojars.org/xyz.zcaudate/riberry)

Riberry client library for Clojure


## Usage


#### API Site Options

```clojure
(require '[riberry.core :as rb]
         '[std.string :as str])

(rb/set-site-opts {:url "https://qa.api.riberry.health"})
=> {:url "https://qa.api.riberry.health"}

;; Retrieves an API Token
(rb/token-get {:login "test0001@zcaudate.xyz",
               :password "<PASSWORD>"})
=> ;; <TOKEN> -> rb/*site-token*

;; Prints out the current token
rb/*site-token*
=> (->> ["eyJhbGciOiJIUz I1NiIsInR5cCI6IkpXVCJ9.eyJ0eXBlIjoiV"
           "XNlciIsIm5hbWVpZCI6ImEyNjM2MTZkLTlkZTktNDZkMy05NGI"
           "2LWEyOTljYmU5YzZhYiIsImltcGVyb25hdG9yaWQiOiIiLCJ2Z"
           "XJzaW9uIjoiMS4xMy4xMiIsIm5iZiI6MTcxMDk5MDQ4NywiZXh"
           "wIjoxNzEzNTgyNDg3LCJpYXQiOjE3MTA5OTA0ODcsImlzcyI6I"
           "mh0dHBzOi8vcWEuYXBpLnJpYmVycnkuaGVhbHRoIiwiYXVkIjo"
           "iaHR0cHM6Ly9xYS5hcGkucmliZXJyeS5oZWFsdGgifQ.ig1xkc"
           "-hq64AToHyhvcfhvuMP9p19yuSEdL5YT9RVc8"]
          (str/join ""))

(rb/token-refresh)
=> ;; <NEW_TOKEN> -> rb/*site-token*
```

#### Create Pipeline

```clojure
TBD
```


#### All Functions

The following are a list of functions available in the `riberry.core` namespace

```clojure
actor-get
assessment-attempt-create
assessment-attempt-get-all-for-actor
assessment-attempt-get-all-for-group
assessment-attempt-delete
assessment-attempt-update
assessment-attempt-get
assessment-attempt-example-pass
assessment-content-example
assessment-content-schema
assessment-content-create
assessment-content-get-all
assessment-content-create-from-zip
assessment-content-delete
assessment-content-update
assessment-content-get
assessment-content-export
assessment-content-download-file
assessment-content-update-from-zip
assessment-content-publish
assessment-sub-attempt-create
assessment-sub-attempt-get-all-for-actor
assessment-sub-attempt-get-all-for-group
assessment-sub-attempt-delete
assessment-sub-attempt-update
assessment-sub-attempt-get
authentication-identity
authentication-impersonate
authentication-permitted
authentication-permitted-all
authentication-refresh-token
authentication-sign-in
authentication-sign-out
authentication-token
authentication-unimpersonate
backup-create
backup-get-all
backup-delete
backup-get
book-attempt-create
book-attempt-get-all-for-actor
book-attempt-get-all-for-group
book-attempt-delete
book-attempt-update
book-attempt-get
book-attempt-example-pass
book-content-example
book-content-schema
book-content-create
book-content-get-all
book-content-create-from-zip
book-content-delete
book-content-update
book-content-get
book-content-export
book-content-download-file
book-content-update-from-zip
book-content-publish
certificate-create
certificate-get-all
certificate-delete
certificate-update
certificate-get
certification-download
certification-get-all-history-for-group
certification-get-all-for-trainee
certification-get-all-history-for-trainee
certification-get
certification-export
class-create
class-get-all
class-delete
class-update
class-get
class-notify-assessors
communication-preferences-unsubscribe-post
communication-preferences-unsubscribe-get
communication-preferences-update
communication-preferences-get
course-create
course-get-all-by-activation
course-get-all-published
course-get-all-for-publisher
course-delete
course-update
course-get
customer-get-for-user
customer-get
email-update
email-get-all
email-get-all-by-user
email-get
email-registration-get
enrolment-get-all-for-class
enrolment-get-all-for-trainee
enrolment-get
external-application-create
external-application-get-all
external-application-delete
external-application-update
external-application-get
group-get
group-attendance-get-all
group-attendance-update
group-attendance-get
group-comment-create
group-comment-get-all
group-comment-delete
group-comment-update
group-comment-get
group-comment-get-all-replies
group-file-create
group-file-get-all
group-file-delete
group-file-update
group-file-get
group-file-download
image-get
implementation-create
implementation-get-all
implementation-delete
implementation-update
implementation-get
implementation-get-all-tasks
item-activation-create
item-activation-get-all-by-activation
item-activation-get2
item-activation-get-all-for-publisher
item-activation-update
item-activation-get
job-type-create
job-type-get-all
job-type-delete
job-type-update
job-type-get
label-create
label-get-all-for-group
label-delete
label-update
label-get
log-get-all
log-get
markdown-preview
meeting-create
meeting-get-all
meeting-delete
meeting-update
meeting-get
meeting-create-file
meeting-get-all-files
meeting-delete-file
meeting-update-file
meeting-get-file
meeting-download-file
member-email-all
member-get-all-for-group
member-get-all-for-child-groups
member-get-all-group-history
member-join
member-leave
member-get
member-add
member-ban
member-email
member-remove
member-update
member-accept-group-invitation
member-get-all-for-user
merchant-create
merchant-create-url
merchant-get-for-organisation
merchant-get
module-create
module-get-all
module-delete
module-update
module-get
module-create-file
module-get-all-files
module-delete-file
module-update-file
module-get-file
module-download-file
module-attempt-get-all-for-actor
module-attempt-get-all-for-group
module-attempt-delete
module-attempt-get
module-nps-create
module-nps-get-all-for-module
module-nps-get-all-for-publisher
module-nps-delete
module-nps-get
notification-get-all
notification-mark-all-as-read
notification-mark-all-as-seen
notification-delete
notification-update
notification-get
observation-create
observation-migration-get-observation-anonymous-users
observation-migration-batch-merge-observation-anonymous-users
observation-extract-labelled-answers
observation-get-all-for-area
observation-get-all-for-group
observation-get-all-for-publisher
observation-predict
observation-delete
observation-update
observation-get
observation-download-file
observation-content-create
observation-content-delete
observation-content-update
observation-content-get
observation-form-get-all-for-observation-content
observation-content-publish
observation-definition-create
observation-definition-get-all-by-activation
observation-definition-get-all-published
observation-definition-get-all-for-publisher
observation-content-get-all
observation-definition-get
observation-definition-delete
observation-definition-update
observation-migration-duplicate-observation-definition
observation-migration-migrate-observation-definition
observation-form-create
observation-form-delete
observation-form-update
observation-form-get
observation-settings-create
observation-settings-get-all
observation-settings-delete
observation-settings-update
observation-settings-get
organisation-create
organisation-get-all
organisation-delete
organisation-update
organisation-get
organisation-access-token-create
organisation-access-token-get-all
organisation-access-token-delete
organisation-access-token-get-all2
password-request-reset
password-reset
password-update
password-get
password-update-two-factor-authentication
payment-create
payment-get
payment-settings-countries
payment-settings-currencies
payment-settings-public-key
payment-settings-regions
phone-number-registration-get
platform-get
platform-default-settings
platform-status
platform-terms
product-create
product-get-all
product-delete
product-update
product-get
program-create
program-get-all-by-activation
program-get-all-published
program-get-all-for-publisher
program-get
program-delete
program-update
program-activation-get-all
program-activation-get2
program-activation-create-by-phase
program-activation-get-all-for-publisher
program-activation-get
program-activation-deactivate
program-activation-set-current-phase
program-phase-create
program-phase-get
program-phase-delete
program-phase-update
projection-get-all
projection-get
publisher-get-all
publisher-get
publisher-approve
publisher-request
quiz-attempt-create
quiz-attempt-get-all-for-actor
quiz-attempt-get-all-for-group
quiz-attempt-delete
quiz-attempt-update
quiz-attempt-get
quiz-attempt-example-pass
quiz-content-example
quiz-content-schema
quiz-content-create
quiz-content-get-all
quiz-content-create-from-zip
quiz-content-delete
quiz-content-update
quiz-content-get
quiz-content-export
quiz-content-download-file
quiz-content-update-from-zip
quiz-content-publish
revision-attempt-create
revision-attempt-get-all-for-actor
revision-attempt-get-all-for-group
revision-attempt-delete
revision-attempt-update
revision-attempt-get
revision-attempt-example-pass
revision-content-example
revision-content-schema
revision-content-create
revision-content-get-all
revision-content-create-from-zip
revision-content-delete
revision-content-update
revision-content-get
revision-content-export
revision-content-download-file
revision-content-update-from-zip
revision-content-publish
role-get-all
role-get
scheduled-email-get-all
scheduled-email-create
scheduled-email-get-all-for-recipient
scheduled-email-get
scheduled-email-delete
scheduled-email-leave
scheduled-email-update
sharing-get-by-alias
sharing-create-for-group-invitation
sharing-get-all-group-invitations-for-group
sharing-delete
stripe-event
survey-create
survey-get-all-by-activation
survey-get-all-published
survey-get-all-for-publisher
survey-get
survey-delete
survey-update
survey-content-create
survey-content-get-all
survey-content-delete
survey-content-update
survey-content-get
survey-content-answer-types
survey-content-example
survey-content-question-types
survey-content-schema
survey-request-create
survey-request-get-all-for-group
survey-request-get-for-token
survey-request-delete
survey-request-get
survey-response-create
survey-response-get-all-for-respondent
survey-response-get-all-for-survey
survey-response-delete
survey-response-update
survey-response-get
task-create
task-get-all
task-delete
task-update
task-get
task-comment-create
task-comment-get-all
task-comment-delete
task-comment-update
task-comment-get
task-comment-get-all-replies
task-file-create
task-file-get-all
task-file-delete
task-file-update
task-file-get
task-file-download
team-create
team-get-all
team-delete
team-update
team-get
ticket-create
ticket-get-all
ticket-update
ticket-get
training-session-create
training-session-get-all
training-session-delete
training-session-update
training-session-get
user-create
user-get-all
user-contact-email-template
user-merge
user-onboard
user-welcome-email-template
user-delete
user-update
user-get
user-activate
user-attendance-get-all
user-attendance-update
user-attendance-get
user-contact
user-send-welcome-email
user-activity-get-all-for-group
user-activity-get-all-for-publisher
user-email-verify-get
user-email-verify-post
user-email-remove
user-email-add
user-email-get
user-email-change-primary
user-email-contact
user-email-send-verification
user-phone-number-verify
user-phone-number-update
user-phone-number-get
user-phone-number-send-verification
video-attempt-create
video-attempt-get-all-for-actor
video-attempt-get-all-for-group
video-attempt-delete
video-attempt-update
video-attempt-get
video-attempt-example-pass
video-content-example
video-content-schema
video-content-create
video-content-get-all
video-content-create-from-zip
video-content-delete
video-content-update
video-content-get
video-content-export
video-content-download-file
video-content-update-from-zip
video-content-publish
survey-content-publish
```




## License

Copyright © 2024 Chris Zheng

Distributed under the MIT License.