# Parser for Gnucash data format

This library is to help with parsing and emitting XML documents of the [Gnucash XML format](https://wiki.gnucash.org/wiki/GnuCash_XML_format)

## Usage

Importing and exporting documents can be done the following way:

```clojure
(require '[com.besenczy.gnucash.core :as gnucash])

(def document-str (slurp "Accounting.gnucash"))
(def imported (gnucash/parse-str document-str))
(def exported (gnucash/emit-str imported))

```

Importing and exporting documents gets validated using the spec `::com.besenczy.gnucash.specs/document`
