(ns com.ben-allred.formation.utils.core)

#?(:clj
   (defmacro silent [form & [else]]
     `(try ~form
           (catch Throwable _#
             ~else)))
   :cljs
   (defmacro silent [form & [else]]
     `(try ~form
           (catch js/Object _#
             ~else))))

(defn deep-into [val-1 val-2]
  (if (or (map? val-1) (map? val-2))
    (merge-with deep-into val-1 val-2)
    (distinct (concat val-1 val-2))))
