(ns com.ben-allred.app-simulator.ui.utils.macros)

(defn set-timeout [f ms]
  #?(:cljs (.setTimeout js/window f ms)))

(defmacro after [ms & body]
  `(set-timeout (fn [] ~@body) ~ms))

(defmacro condp-> [pred expr & clauses]
  (assert (even? (count clauses)))
  (let [g (gensym)
        steps (map (fn [[test step]] `(if (~pred ~test ~g) (-> ~g ~step) ~g))
                   (partition 2 clauses))]
    `(let [~g ~expr
           ~@(interleave (repeat g) (butlast steps))]
       ~(if (empty? steps)
          g
          (last steps)))))
