/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.pbc.RiakConnectionPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class PoolSemaphore
extends Semaphore {
    private static final long serialVersionUID = -2559842472836477776L;
    private final Semaphore clusterSemaphore;
    private final Semaphore poolSemaphore;

    public PoolSemaphore(Semaphore clusterSemaphore, int poolPermits) {
        super(0, true);
        this.clusterSemaphore = clusterSemaphore;
        this.poolSemaphore = RiakConnectionPool.getSemaphore(poolPermits);
    }

    public void release() {
        this.clusterSemaphore.release();
        this.poolSemaphore.release();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        boolean clusterPermitted = this.clusterSemaphore.tryAcquire(timeout, unit);
        boolean poolPermitted = false;
        if (clusterPermitted) {
            try {
                poolPermitted = this.poolSemaphore.tryAcquire(timeout, unit);
            }
            catch (InterruptedException e) {
                this.clusterSemaphore.release();
                throw e;
            }
        }
        if (poolPermitted) {
            return true;
        }
        if (clusterPermitted) {
            this.clusterSemaphore.release();
        }
        return false;
    }

    public boolean tryAcquire(int permits) {
        boolean clusterPermitted = this.clusterSemaphore.tryAcquire(permits);
        boolean poolPermitted = false;
        if (clusterPermitted) {
            poolPermitted = this.poolSemaphore.tryAcquire(permits);
        }
        if (poolPermitted) {
            return true;
        }
        if (clusterPermitted) {
            this.clusterSemaphore.release(permits);
        }
        return false;
    }
}

