/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.raw.config.Configuration;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;

public class HTTPClientConfig
implements Configuration {
    private final String url;
    private final String mapreducePath;
    private final HttpClient httpClient;
    private final Integer timeout;
    private final Integer maxConnections;
    private final HttpRequestRetryHandler retryHandler;

    private HTTPClientConfig(String url, String mapreducePath, HttpClient httpClient, Integer timeout, Integer maxConnections, HttpRequestRetryHandler retryHandler) {
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.url = url;
        this.mapreducePath = mapreducePath;
        this.httpClient = httpClient;
        this.timeout = timeout;
        this.maxConnections = maxConnections;
        this.retryHandler = retryHandler;
    }

    public static HTTPClientConfig defaults() {
        return new Builder().build();
    }

    public String getUrl() {
        return this.url;
    }

    public String getMapreducePath() {
        return this.mapreducePath;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public HttpRequestRetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public static final class Builder {
        private String url = null;
        private String scheme = "http";
        private String host = "127.0.0.1";
        private int port = 8098;
        private String riakPath = "/riak";
        private String mapreducePath = "/mapred";
        private HttpClient httpClient = null;
        private Integer timeout = null;
        private Integer maxConnections = null;
        private HttpRequestRetryHandler retryHandler = null;

        public HTTPClientConfig build() {
            if (this.url == null) {
                StringBuilder sb = new StringBuilder(this.scheme).append("://").append(this.host).append(":").append(this.port);
                if (!this.riakPath.startsWith("/")) {
                    sb.append("/");
                }
                this.url = sb.append(this.riakPath).toString();
            }
            return new HTTPClientConfig(this.url, this.mapreducePath, this.httpClient, this.timeout, this.maxConnections, this.retryHandler);
        }

        public static Builder from(HTTPClientConfig copyConfig) {
            Builder b = new Builder();
            b.url = copyConfig.url;
            b.mapreducePath = copyConfig.mapreducePath;
            b.httpClient = copyConfig.httpClient;
            b.timeout = copyConfig.timeout;
            b.maxConnections = copyConfig.maxConnections;
            b.retryHandler = copyConfig.retryHandler;
            return b;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withRiakPath(String path) {
            this.riakPath = path;
            return this;
        }

        public Builder withMapreducePath(String path) {
            this.mapreducePath = path;
            return this;
        }

        public Builder withHttpClient(HttpClient client) {
            this.httpClient = client;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withMaxConnctions(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder withRetryHandler(HttpRequestRetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }
    }
}

