/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw;

import java.util.Date;

public class StoreMeta {
    private static final StoreMeta EMPTY = new StoreMeta(null, null, null, false, null, null);
    private final Integer w;
    private final Integer dw;
    private final Integer pw;
    private final Boolean returnBody;
    private final Boolean returnHead;
    private final Boolean ifNoneMatch;
    private final Boolean ifNotModified;
    private String[] etags;
    private Long lastModified;

    public StoreMeta(Integer w, Integer dw, Integer pw, Boolean returnBody, Boolean ifNoneMatch, Boolean ifNotModified) {
        this(w, dw, pw, returnBody, null, ifNoneMatch, ifNotModified);
    }

    public StoreMeta(Integer w, Integer dw, Integer pw, Boolean returnBody, Boolean returnHead, Boolean ifNoneMatch, Boolean ifNotModified) {
        this.w = w;
        this.dw = dw;
        this.pw = pw;
        this.returnBody = returnBody;
        this.returnHead = returnHead;
        this.ifNoneMatch = ifNoneMatch;
        this.ifNotModified = ifNotModified;
    }

    public Integer getW() {
        return this.w;
    }

    public boolean hasW() {
        return this.w != null;
    }

    public Integer getDw() {
        return this.dw;
    }

    public boolean hasDw() {
        return this.dw != null;
    }

    public boolean hasReturnBody() {
        return this.returnBody != null;
    }

    public Boolean getReturnBody() {
        return this.returnBody;
    }

    public boolean hasPw() {
        return this.pw != null;
    }

    public Integer getPw() {
        return this.pw;
    }

    public boolean hasIfNoneMatch() {
        return this.ifNoneMatch != null;
    }

    public Boolean getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public boolean isIfNoneMatch() {
        return this.hasIfNoneMatch() && this.ifNoneMatch != false;
    }

    public boolean hasIfNotModified() {
        return this.ifNotModified != null;
    }

    public Boolean getIfNotModified() {
        return this.ifNotModified;
    }

    public boolean isIfNotModified() {
        return this.hasIfNotModified() && this.ifNotModified != false;
    }

    public static StoreMeta empty() {
        return EMPTY;
    }

    public boolean hasReturnHead() {
        return this.returnHead != null;
    }

    public Boolean getReturnHead() {
        return this.returnHead;
    }

    public synchronized StoreMeta etags(String[] etags) {
        if (etags != null) {
            this.etags = (String[])etags.clone();
        }
        return this;
    }

    public synchronized String[] getEtags() {
        if (this.etags != null) {
            return (String[])this.etags.clone();
        }
        return null;
    }

    public synchronized Date getLastModified() {
        if (this.lastModified != null) {
            return new Date(this.lastModified);
        }
        return null;
    }

    public synchronized StoreMeta lastModified(Date lastModified) {
        if (lastModified != null) {
            this.lastModified = lastModified.getTime();
        }
        return this;
    }

    public static StoreMeta headOnly() {
        return new StoreMeta(null, null, null, null, true, null, null);
    }

    public static class Builder {
        private Integer w;
        private Integer dw;
        private Integer pw;
        private Boolean returnBody;
        private Boolean returnHead;
        private Boolean ifNotModified;
        private Boolean ifNoneMatch;

        public StoreMeta build() {
            return new StoreMeta(this.w, this.dw, this.pw, this.returnBody, this.returnHead, this.ifNoneMatch, this.ifNotModified);
        }

        public Builder w(int w) {
            this.w = w;
            return this;
        }

        public Builder dw(int dw) {
            this.dw = dw;
            return this;
        }

        public Builder pw(int pw) {
            this.pw = pw;
            return this;
        }

        public Builder returnBody(boolean returnBody) {
            this.returnBody = returnBody;
            return this;
        }

        public Builder returnHead(boolean returnHead) {
            this.returnHead = returnHead;
            return this;
        }

        public Builder ifNotModified(boolean ifNotModified) {
            this.ifNotModified = ifNotModified;
            return this;
        }

        public Builder ifNoneMatch(boolean ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }
    }
}

