/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import com.basho.riak.client.raw.StoreMeta;
import com.basho.riak.client.raw.config.ClusterConfig;
import com.basho.riak.client.raw.config.Configuration;
import com.basho.riak.client.raw.query.LinkWalkSpec;
import com.basho.riak.client.raw.query.MapReduceSpec;
import com.basho.riak.client.raw.query.MapReduceTimeoutException;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusterClient<T extends Configuration>
implements RawClient {
    private final RawClient[] cluster;
    private final int clusterSize;
    private final AtomicInteger counter;

    public ClusterClient(ClusterConfig<T> clusterConfig) throws IOException {
        this.cluster = this.fromConfig(clusterConfig);
        this.clusterSize = this.cluster.length;
        this.counter = new AtomicInteger(0);
    }

    protected abstract RawClient[] fromConfig(ClusterConfig<T> var1) throws IOException;

    private RawClient getDelegate() {
        int delegateIndex = Math.abs(this.counter.getAndIncrement() % this.clusterSize);
        return this.cluster[delegateIndex];
    }

    @Override
    public RiakResponse head(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.head(bucket, key, fetchMeta);
    }

    @Override
    public RiakResponse fetch(String bucket, String key) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.fetch(bucket, key);
    }

    @Override
    public RiakResponse fetch(String bucket, String key, int readQuorum) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.fetch(bucket, key, readQuorum);
    }

    @Override
    public RiakResponse fetch(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.fetch(bucket, key, fetchMeta);
    }

    @Override
    public RiakResponse store(IRiakObject object, StoreMeta storeMeta) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.store(object, storeMeta);
    }

    @Override
    public void store(IRiakObject object) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.store(object);
    }

    @Override
    public void delete(String bucket, String key) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.delete(bucket, key);
    }

    @Override
    public void delete(String bucket, String key, int deleteQuorum) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.delete(bucket, key, deleteQuorum);
    }

    @Override
    public void delete(String bucket, String key, DeleteMeta deleteMeta) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.delete(bucket, key, deleteMeta);
    }

    @Override
    public Set<String> listBuckets() throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.listBuckets();
    }

    @Override
    public BucketProperties fetchBucket(String bucketName) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.fetchBucket(bucketName);
    }

    @Override
    public void updateBucket(String name, BucketProperties bucketProperties) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.updateBucket(name, bucketProperties);
    }

    @Override
    public Iterable<String> listKeys(String bucketName) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.listKeys(bucketName);
    }

    @Override
    public WalkResult linkWalk(LinkWalkSpec linkWalkSpec) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.linkWalk(linkWalkSpec);
    }

    @Override
    public MapReduceResult mapReduce(MapReduceSpec spec) throws IOException, MapReduceTimeoutException {
        RawClient delegate = this.getDelegate();
        return delegate.mapReduce(spec);
    }

    @Override
    public byte[] generateAndSetClientId() throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.generateAndSetClientId();
    }

    @Override
    public void setClientId(byte[] clientId) throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.setClientId(clientId);
    }

    @Override
    public byte[] getClientId() throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.getClientId();
    }

    @Override
    public void ping() throws IOException {
        RawClient delegate = this.getDelegate();
        delegate.ping();
    }

    @Override
    public List<String> fetchIndex(IndexQuery indexQuery) throws IOException {
        RawClient delegate = this.getDelegate();
        return delegate.fetchIndex(indexQuery);
    }
}

