/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.operations;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.cap.ClobberMutation;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.Mutation;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.cap.UnresolvedConflictException;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.operations.FetchObject;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import com.basho.riak.client.raw.StoreMeta;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreObject<T>
implements RiakOperation<T> {
    private final RawClient client;
    private final FetchObject<T> fetchObject;
    private Retrier retrier;
    private final StoreMeta.Builder storeMetaBuilder = new StoreMeta.Builder();
    private boolean returnBody = false;
    private Mutation<T> mutation;
    private ConflictResolver<T> resolver;
    private Converter<T> converter;

    public StoreObject(RawClient client, String bucket, String key, Retrier retrier) {
        this.client = client;
        this.retrier = retrier;
        this.fetchObject = new FetchObject(client, bucket, key, retrier);
    }

    @Override
    public T execute() throws RiakRetryFailedException, UnresolvedConflictException, ConversionException {
        T resolved = this.fetchObject.execute();
        T mutated = this.mutation.apply(resolved);
        final IRiakObject o = this.converter.fromDomain(mutated, this.fetchObject.getVClock());
        final StoreMeta storeMeta = this.storeMetaBuilder.returnBody(this.returnBody).build();
        if (storeMeta.hasIfNoneMatch() && storeMeta.getIfNoneMatch().booleanValue() && o != null) {
            storeMeta.etags(new String[]{o.getVtag()});
        }
        if (storeMeta.hasIfNotModified() && storeMeta.getIfNotModified().booleanValue() && o != null) {
            storeMeta.lastModified(o.getLastModified());
        }
        RiakResponse stored = this.retrier.attempt(new Callable<RiakResponse>(){

            @Override
            public RiakResponse call() throws Exception {
                return StoreObject.this.client.store(o, storeMeta);
            }
        });
        ArrayList<T> storedSiblings = new ArrayList<T>(stored.numberOfValues());
        for (IRiakObject s : stored) {
            storedSiblings.add(this.converter.toDomain(s));
        }
        return this.resolver.resolve(storedSiblings);
    }

    public StoreObject<T> r(int r) {
        this.fetchObject.r(r);
        return this;
    }

    public StoreObject<T> pr(int pr) {
        this.fetchObject.pr(pr);
        return this;
    }

    public StoreObject<T> notFoundOK(boolean notFoundOK) {
        this.fetchObject.notFoundOK(notFoundOK);
        return this;
    }

    public StoreObject<T> basicQuorum(boolean basicQuorum) {
        this.fetchObject.basicQuorum(basicQuorum);
        return this;
    }

    public StoreObject<T> returnDeletedVClock(boolean returnDeletedVClock) {
        this.fetchObject.returnDeletedVClock(returnDeletedVClock);
        return this;
    }

    public StoreObject<T> pw(int pw) {
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public StoreObject<T> w(int w) {
        this.storeMetaBuilder.w(w);
        return this;
    }

    public StoreObject<T> dw(int dw) {
        this.storeMetaBuilder.dw(dw);
        return this;
    }

    public StoreObject<T> returnBody(boolean returnBody) {
        this.returnBody = returnBody;
        return this;
    }

    public StoreObject<T> ifNoneMatch(boolean ifNoneMatch) {
        this.storeMetaBuilder.ifNoneMatch(ifNoneMatch);
        return this;
    }

    public StoreObject<T> ifNotModified(boolean ifNotModified) {
        this.storeMetaBuilder.ifNotModified(ifNotModified);
        return this;
    }

    public StoreObject<T> withRetrier(Retrier retrier) {
        this.retrier = retrier;
        this.fetchObject.withRetrier(retrier);
        return this;
    }

    public StoreObject<T> withMutator(Mutation<T> mutation) {
        this.mutation = mutation;
        return this;
    }

    public StoreObject<T> withResolver(ConflictResolver<T> resolver) {
        this.resolver = resolver;
        this.fetchObject.withResolver(resolver);
        return this;
    }

    public StoreObject<T> withConverter(Converter<T> converter) {
        this.converter = converter;
        this.fetchObject.withConverter(converter);
        return this;
    }

    public StoreObject<T> withValue(T value) {
        this.mutation = new ClobberMutation<T>(value);
        return this;
    }
}

