/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.operations;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteObject
implements RiakOperation<Void> {
    private final RawClient client;
    private final String bucket;
    private final String key;
    private Retrier retrier;
    private boolean fetchBeforeDelete = false;
    private final DeleteMeta.Builder deleteMetaBuilder = new DeleteMeta.Builder();
    private final FetchMeta.Builder fetchMetaBuilder = new FetchMeta.Builder();

    public DeleteObject(RawClient client, String bucket, String key, Retrier retrier) {
        this.client = client;
        this.bucket = bucket;
        this.key = key;
        this.retrier = retrier;
    }

    @Override
    public Void execute() throws RiakException {
        if (this.fetchBeforeDelete) {
            Callable<VClock> fetch = new Callable<VClock>(){

                @Override
                public VClock call() throws Exception {
                    RiakResponse response = DeleteObject.this.client.head(DeleteObject.this.bucket, DeleteObject.this.key, DeleteObject.this.fetchMetaBuilder.build());
                    return response.getVclock();
                }
            };
            this.deleteMetaBuilder.vclock(this.retrier.attempt(fetch));
        }
        Callable<Void> command = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DeleteObject.this.client.delete(DeleteObject.this.bucket, DeleteObject.this.key, DeleteObject.this.deleteMetaBuilder.build());
                return null;
            }
        };
        this.retrier.attempt(command);
        return null;
    }

    public DeleteObject r(int r) {
        this.fetchMetaBuilder.r(r);
        this.deleteMetaBuilder.r(r);
        return this;
    }

    public DeleteObject pr(int pr) {
        this.fetchMetaBuilder.pr(pr);
        this.deleteMetaBuilder.pr(pr);
        return this;
    }

    public DeleteObject w(int w) {
        this.deleteMetaBuilder.w(w);
        return this;
    }

    public DeleteObject dw(int dw) {
        this.deleteMetaBuilder.dw(dw);
        return this;
    }

    public DeleteObject pw(int pw) {
        this.deleteMetaBuilder.pw(pw);
        return this;
    }

    public DeleteObject rw(int rw) {
        this.deleteMetaBuilder.rw(rw);
        return this;
    }

    public DeleteObject vclock(VClock vclock) {
        this.deleteMetaBuilder.vclock(vclock);
        return this;
    }

    public DeleteObject withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    public DeleteObject fetchBeforeDelete(boolean fetch) {
        this.fetchBeforeDelete = fetch;
        return this;
    }
}

