/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert.reflect;

import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.basho.riak.client.convert.RiakLinks;
import com.basho.riak.client.convert.RiakUsermeta;
import com.basho.riak.client.convert.UsermetaField;
import com.basho.riak.client.convert.reflect.AnnotationInfo;
import com.basho.riak.client.convert.reflect.ClassUtil;
import com.basho.riak.client.convert.reflect.RiakIndexField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner
implements Callable<AnnotationInfo> {
    private final Class classToScan;

    public AnnotationScanner(Class clazz) {
        this.classToScan = clazz;
    }

    @Override
    public AnnotationInfo call() throws Exception {
        Field[] fields;
        Field riakKeyField = null;
        Field usermetaMapField = null;
        Field linksField = null;
        ArrayList<UsermetaField> usermetaItemFields = new ArrayList<UsermetaField>();
        ArrayList<RiakIndexField> indexFields = new ArrayList<RiakIndexField>();
        for (Field field : fields = this.classToScan.getDeclaredFields()) {
            if (field.isAnnotationPresent(RiakKey.class)) {
                riakKeyField = ClassUtil.checkAndFixAccess(field);
            }
            if (field.isAnnotationPresent(RiakUsermeta.class)) {
                RiakUsermeta a = field.getAnnotation(RiakUsermeta.class);
                String key = a.key();
                if (!"".equals(key)) {
                    usermetaItemFields.add(new UsermetaField(ClassUtil.checkAndFixAccess(field)));
                } else {
                    usermetaMapField = ClassUtil.checkAndFixAccess(field);
                }
            }
            if (field.isAnnotationPresent(RiakIndex.class)) {
                indexFields.add(new RiakIndexField(ClassUtil.checkAndFixAccess(field)));
            }
            if (!field.isAnnotationPresent(RiakLinks.class)) continue;
            linksField = ClassUtil.checkAndFixAccess(field);
        }
        return new AnnotationInfo(riakKeyField, usermetaItemFields, usermetaMapField, indexFields, linksField);
    }
}

