/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.bucket.DefaultBucket;
import com.basho.riak.client.bucket.UnsupportedPropertyException;
import com.basho.riak.client.builders.BucketPropertiesBuilder;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.Transport;
import java.util.Collection;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteBucket
implements RiakOperation<Bucket> {
    private final RawClient client;
    private Retrier retrier;
    private String name;
    private BucketPropertiesBuilder builder = new BucketPropertiesBuilder();

    public WriteBucket(RawClient client, String name, Retrier retrier) {
        this.name = name;
        this.client = client;
        this.retrier = retrier;
    }

    @Override
    public Bucket execute() throws RiakRetryFailedException {
        final BucketProperties propsToStore = this.builder.build();
        this.retrier.attempt(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WriteBucket.this.client.updateBucket(WriteBucket.this.name, propsToStore);
                return null;
            }
        });
        BucketProperties properties = this.retrier.attempt(new Callable<BucketProperties>(){

            @Override
            public BucketProperties call() throws Exception {
                return WriteBucket.this.client.fetchBucket(WriteBucket.this.name);
            }
        });
        return new DefaultBucket(this.name, properties, this.client, this.retrier);
    }

    public WriteBucket allowSiblings(boolean allowSiblings) {
        this.builder.allowSiblings(allowSiblings);
        return this;
    }

    public WriteBucket lastWriteWins(boolean lastWriteWins) {
        this.httpOnly(this.client.getTransport(), "last_write_wins");
        this.builder.lastWriteWins(lastWriteWins);
        return this;
    }

    public WriteBucket nVal(int nVal) {
        this.builder.nVal(nVal);
        return this;
    }

    public WriteBucket backend(String backend) {
        this.httpOnly(this.client.getTransport(), "backend");
        this.builder.backend(backend);
        return this;
    }

    public WriteBucket precommitHooks(Collection<NamedFunction> precommitHooks) {
        this.httpOnly(this.client.getTransport(), "precommit");
        this.builder.precommitHooks(precommitHooks);
        return this;
    }

    public WriteBucket addPrecommitHook(NamedFunction preCommitHook) {
        this.httpOnly(this.client.getTransport(), "precommit");
        this.builder.addPrecommitHook(preCommitHook);
        return this;
    }

    public WriteBucket postcommitHooks(Collection<NamedErlangFunction> postCommitHooks) {
        this.httpOnly(this.client.getTransport(), "postcommit");
        this.builder.postcommitHooks(postCommitHooks);
        return this;
    }

    public WriteBucket addPostcommitHook(NamedErlangFunction postcommitHook) {
        this.httpOnly(this.client.getTransport(), "postcommit");
        this.builder.addPostcommitHook(postcommitHook);
        return this;
    }

    public WriteBucket chashKeyFunction(NamedErlangFunction chashKeyFunction) {
        this.httpOnly(this.client.getTransport(), "chash_keyfun");
        this.builder.chashKeyFunction(chashKeyFunction);
        return this;
    }

    public WriteBucket linkWalkFunction(NamedErlangFunction linkWalkFunction) {
        this.httpOnly(this.client.getTransport(), "linkfun");
        this.builder.linkWalkFunction(linkWalkFunction);
        return this;
    }

    public WriteBucket smallVClock(int smallVClock) {
        this.httpOnly(this.client.getTransport(), "small_vclock");
        this.builder.smallVClock(smallVClock);
        return this;
    }

    public WriteBucket bigVClock(int bigVClock) {
        this.httpOnly(this.client.getTransport(), "big_vclock");
        this.builder.bigVClock(bigVClock);
        return this;
    }

    public WriteBucket youngVClock(long youngVClock) {
        this.httpOnly(this.client.getTransport(), "young_vclock");
        this.builder.youngVClock(youngVClock);
        return this;
    }

    public WriteBucket oldVClock(long oldVClock) {
        this.httpOnly(this.client.getTransport(), "old_vclock");
        this.builder.oldVClock(oldVClock);
        return this;
    }

    public WriteBucket r(Quora r) {
        this.httpOnly(this.client.getTransport(), "r");
        this.builder.r(r);
        return this;
    }

    public WriteBucket r(int r) {
        this.httpOnly(this.client.getTransport(), "r");
        this.builder.r(r);
        return this;
    }

    public WriteBucket w(Quora w) {
        this.httpOnly(this.client.getTransport(), "w");
        this.builder.w(w);
        return this;
    }

    public WriteBucket w(int w) {
        this.httpOnly(this.client.getTransport(), "w");
        this.builder.w(w);
        return this;
    }

    public WriteBucket rw(Quora rw) {
        this.httpOnly(this.client.getTransport(), "rw");
        this.builder.rw(rw);
        return this;
    }

    public WriteBucket rw(int rw) {
        this.httpOnly(this.client.getTransport(), "rw");
        this.builder.rw(rw);
        return this;
    }

    public WriteBucket dw(Quora dw) {
        this.httpOnly(this.client.getTransport(), "dw");
        this.builder.dw(dw);
        return this;
    }

    public WriteBucket dw(int dw) {
        this.httpOnly(this.client.getTransport(), "dw");
        this.builder.dw(dw);
        return this;
    }

    public WriteBucket pr(Quora pr) {
        this.httpOnly(this.client.getTransport(), "pr");
        this.builder.pr(pr);
        return this;
    }

    public WriteBucket pr(int pr) {
        this.httpOnly(this.client.getTransport(), "pr");
        this.builder.pr(pr);
        return this;
    }

    public WriteBucket pw(Quora pw) {
        this.httpOnly(this.client.getTransport(), "pw");
        this.builder.pw(pw);
        return this;
    }

    public WriteBucket pw(int pw) {
        this.httpOnly(this.client.getTransport(), "pw");
        this.builder.pw(pw);
        return this;
    }

    public WriteBucket basicQuorum(boolean basicQuorum) {
        this.httpOnly(this.client.getTransport(), "basic_quorum");
        this.builder.basicQuorum(basicQuorum);
        return this;
    }

    public WriteBucket notFoundOK(boolean notFoundOK) {
        this.httpOnly(this.client.getTransport(), "notfound_ok");
        this.builder.notFoundOK(notFoundOK);
        return this;
    }

    public WriteBucket withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    public WriteBucket enableForSearch() {
        this.httpOnly(this.client.getTransport(), "search");
        this.builder.addPrecommitHook(NamedErlangFunction.SEARCH_PRECOMMIT_HOOK).search(true);
        return this;
    }

    private void httpOnly(Transport transport, String propertyName) {
        if (!Transport.HTTP.equals((Object)transport)) {
            throw new UnsupportedPropertyException(transport, propertyName);
        }
    }
}

