/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.bucket.DefaultBucket;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.raw.RawClient;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchBucket
implements RiakOperation<Bucket> {
    private final RawClient client;
    private final String bucket;
    private Retrier retrier;

    public FetchBucket(RawClient client, String bucket, Retrier retrier) {
        this.client = client;
        this.bucket = bucket;
        this.retrier = retrier;
    }

    @Override
    public Bucket execute() throws RiakRetryFailedException {
        BucketProperties properties = this.retrier.attempt(new Callable<BucketProperties>(){

            @Override
            public BucketProperties call() throws Exception {
                return FetchBucket.this.client.fetchBucket(FetchBucket.this.bucket);
            }
        });
        return new DefaultBucket(this.bucket, properties, this.client, this.retrier);
    }

    public FetchBucket withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }
}

