(ns platform-order.storage
  (:refer-clojure :exclude [pop!]))

(defprotocol Storage
  (connect!    [adapter] "Connects to the storage device.")
  (disconnect! [adapter] "Disconnects from the storage device.") 
  (add!        [adapter item] "Adds an item to the end of the queue.")
  (pop!        [adapter] "Removes and fetches the item at the beginning of the queue.")
  (fail!       [adapter item] "Sends item to the failure list.")
  (length      [adapter] "Returns integer length of the queue.")
  (fetch       [adapter] "Returns the entire queue."))
