# 3. Implementation of source mapping

Date: 09-01-2023

## Status

Accepted

## Context

One of the desired features for the logging service to implement is source mapping. 
Source mapping allows the compiled code to be translated back towards the read able code a developer can read.

In order to implement sourcemapping, we need to implement the following points:

- How to make a sourcemap and keep it private.
- How to get the sourcemap to the external logging service.
- how to deconstruct en send the error for it can be translated.

In this ADR we are gone look at these three points and see how we can implement is and what the best option is.

## Options

### Creating the source map

For this section we are concered about making the sourcemap, here we need to meet the following requirements:

- We need to be able to keep the sourcemap private, the user should not be able to see the sourcemap tru the developer tools in their browser.

In shadow-cljs it is possible to make a source-map during the compilation of a project.
This allows us to generate the sourcemap during the build pipeline of the project, with very little modification needed. 
Instruction on to do this are listed here: https://shadow-cljs.github.io/docs/UsersGuide.html#compiler-options



### Sending the sourcemap to rollbar

//TODO via terminal command als permanente oplossing. 
//TODO Als ik hier geen toegang tot krijg is handmattig oploaden voor demo reden mogelijk.

According to the rollbar. There are multiple options to send the sourcemap to Rollbar.
In dit part we wil look at the opties listed in Rollbar's documentation and select the opties best for is.
Because we selected the Rollbar service we do not have to look at external libraries or other sources to find potential selutions.
The source for this section is: https://docs.rollbar.com/docs/source-maps 

**Uploading via shell command**

**Uploading trough the rollbar SKD**

**Uploading sourcemap without sources included**

**Uploading via Rollbar-CLI**

### Deconstructing error to external logging service

## Decision

### Creating source map

### Sending source map

### Using sourcemap
