(ns com.avisi-apps.gaps.log)

(defn- log-expr
  [token level data m]
  `(log
     ~{:token token
       :level level
       :line (:line m)
       :file (:file m)
       :ns (str *ns*)
       :data data}))

(defmacro debug [data & [token]] (log-expr token :debug data (meta &form)))

(defmacro info [data & [token]] (log-expr  token :info data (meta &form)))

(defmacro warn [data & [token]] (log-expr  token :warn data (meta &form)))

(defmacro error [error data & [token]] (log-expr token :error `(assoc ~data :error ~error) (meta &form)))

(defmacro spy
  [form]
  (let [res (gensym)]
    `(let [~res ~form]
       ~(log-expr
          "noToken"
          :debug
          `{:spy ~(str form)
            :=> (str ~res)}
          (meta &form))
       ~res)))
