(ns com.avisi-apps.gaps.log)

(defn- log-expr
  [rollbarConfig level data m]
  `(log
     ~{:rollbarConfig rollbarConfig
       :level level
       :line (:line m)
       :file (:file m)
       :ns (str *ns*)
       :data data}))

(defmacro debug [data & [rollbarConfig]] (log-expr rollbarConfig :debug data (meta &form)))

(defmacro info [data & [rollbarConfig]] (log-expr  rollbarConfig :info data (meta &form)))

(defmacro warn [data & [rollbarConfig]] (log-expr  rollbarConfig :warn data (meta &form)))

(defmacro error [error data & [rollbarConfig]] (log-expr rollbarConfig :error `(assoc ~data :error ~error) (meta &form)))

(defmacro spy
  [form]
  (let [res (gensym)]
    `(let [~res ~form]
       ~(log-expr
          "noToken"
          :debug
          `{:spy ~(str form)
            :=> (str ~res)}
          (meta &form))
       ~res)))
