# 1. Logging Services

Date: 25-10-2022

## Status

Suggested

## Context

For our implementation of a logging service for our apps. 
We are looking if there is a already existing logging service available that meets as much of our needs already, that we can integrate with.
For this we are looking at their feature set, alongside it would be nice to have sometype of analitics available. 
Besides these functionalities it is important that the service has good security features and is compliant with privacy laws.

## Options

There are many options when it comes to client side logging services. In this ADR we are going to look at the folowing 5:

- [Rollbar](https://rollbar.com/)
- [LogRocket](https://logrocket.com/for/how-to-log-client-side-javascript-errors/)
- [Elmah.io](https://elmah.io/features/clientside-logging/)
- [Sentry](https://sentry.io/welcome/)
- [Solarwinds Loggly](https://www.loggly.com/blog/best-practices-for-client-side-logging-and-error-handling-in-react/)

## Requirements

The services need to meet certain requirements.

**Security:**
 
- Compliant with EU privacy laws
- Good security certificates such as SOC2, ISO-27001 & GDPR compliance.

**Functionality:**

- Ability to send direct error messages in order to avoid the console.
- Support for sourcemaps
- Metrics and Notification, would be nice either in the product or a option to integrate with a service that provides that.
- Build in support to include browserinformation with the log messages.

**Pricing:**

- We want to pay on a basis of per app or per x amounts of errors per month. So we don't overpay for funtionality we dont need or for unused bandwith.

## Decision

### Chosen solution: Rollbar

Given the requirements Rollbar is the service that meets our requirements the best. 

- Rollbar had good integration with the other tools witch we use such as: Slack, github, Jira and PagerDuty, for these intergrations there are docs provided by Rolbar on how to set them up.
- Further is there good documentation available over their API, functionality and is there support for sourcemaps build in.
- Rollbar also support some form of browserinformation, however it is not clear if this data is collected for us or if we need to do that ourselves.
- Security wise they have many standards and laws they are compliant with, including SOC2 & ISO-27001.
- They also have good pricing, the tiers they specify are mainly sepperated bij the amounts of events (messages/errors) a month. Going up in tiers from a feature standpoint is not needed since the lowest tier contains every feature we need.


### Not chosen solutions
**LogRocket**

LogRocket is not a suitable service for our needs and does not meet our requirements. This is why LogRocket was not chosen as the solution.

LogRocket works mainly based on listening to the already existing error calls from javascript this means that all error's have to be publicly thrown which makes them visible for our customers.
This is problamatic for our wish to use sourcemaps because they have to public in order to end up in LogRocket. The documentation confirms that sourcemaps do not work when they are kept private. Because of LogRockets implementation it would not be practical for us to implement. We want to log only when the user gives concent, so we need to disable this functionality from LogRocket.
LogRocket also collects a lot of data we dont want to collect that we need to disable since it seems to be active by default.

At last pricing on LogRocket is per session, This is because LogRocket has a strong focus on user minotoring and behavioural insight. This is not favorable for us.

**Elmah.io**

Elmah.io was a potential condidate. But it was not choosen due to a lack of features compaired to other services.

- It does not supports sourcemaps.
- It also has a less extensive security program/certifications then Rollbar.

**Sentry**

Sentry is a good option it contains all the features we need. It lacks the bonus features that Rollbar offers like strong integration support. 

- It has good support for the the requirements we specified.
- It supports sourcemaps with the ability to send them straight tru to Sentry without making it public.
- It also offers a similair pricing structure compaired to Rollbar.
- Sentry has similiar security certificates (SOC2 & ISO-27001).

**Solarwinds Loggly**

Loggly is missing requirements that other service such as Rolbar & Sentry do have. Loggly was not chosen as a solution for this reason.

- No support for sourcemaps in their documentation. 
- The API documentation is not as comprehensive as: Rollbar & Sentry.
