(ns atomist.promise
  (:require [atomist.log :as log]
            [cljs.core.async :refer [<! >! chan] :refer-macros [go]]))

(defn chan->promise
  "convert a channel into a Promise
     - value of Promise can not be nil (Promise reject if chan emits a nil)"
  [chan]
  (js/Promise.
   (fn [accept reject]
     (go
       (try
         (let [v (<! chan)]
           (if v
             (accept v)
             (do
               (log/warn "reject nil on chan->promise")
               (reject (clj->js {:fail "nil value on channel"})))))
         (catch :default t
           (log/error t " js Promise will reject")
           (log/error chan)
           (reject (clj->js {:fail "failure to process chan"
                             :error t}))))))))
