(ns atomist.promise
  (:require [atomist.log :as log]
            [clojure.core.async :refer [<! go]]))

(defn chan->promise
  "convert a channel into a Promise
     - value of Promise can not be nil (Promise reject if chan emits a nil)"
  [chan]
  (let [p (promise)]
    (go
      (try
        (let [v (<! chan)]
          (if v
            (deliver p v)
            (do
              (log/warn "reject nil on chan->promise")
              (deliver p nil))))
        (catch :default t
          (log/error t " js Promise will reject")
          (log/error chan)
          (deliver p t))))
    p))