(ns atomist.zip
  (:require ["archiver" :as archiver]
            ["fs" :as fs]
            [cljs.core.async :refer [<! >! chan] :refer-macros [go]]
            [atomist.log :as log]))

(defn archive [f]
  (go
    (log/info "create a zip archive at " f)
    (try
      (let [archive (archiver. "zip" #js {:zlib {:level 9}})
            output (.createWriteStream fs (.getPath f))
            finished-chan (chan)]
        (.on output "end" (fn [] (go (>! finished-chan :end))))
        (.on output "close" (fn [] (go (>! finished-chan :closed))))
        (.on output "warning" (fn [] (go (>! finished-chan :warning))))
        (.on output "error" (fn [] (go (>! finished-chan :error))))

       ;; ARCHIVE RULES
        (.pipe archive output)
        (.glob archive "*.js")
        (.glob archive "*.edn")
        (.glob archive "*.json")
        (.glob archive "graphql/*/*.graphql")

       ;; status
        (.finalize archive)
        (let [zip-result (<! finished-chan)]
          (clj->js {:result {f (str zip-result)}})))
      (catch :default ex
        (log/error ex ":  archive failure")
        :failed))))
