(ns atomist.skillspec
  (:require #?(:cljs [cljs.spec.alpha :as spec]
               :clj [clojure.spec.alpha :as spec])))

(spec/def ::name string?)
(spec/def ::value string?)
(spec/def ::description string?)
(spec/def ::displayName string?)
(spec/def ::pattern string?)
(spec/def ::typeName string?)
(spec/def ::minRequired int?)
(spec/def ::maxAllowed int?)

(spec/def :parameter/base (spec/keys :req_un [::name :parameter/required ::description]
                                     :opt_un [:skill/displayName]))

(spec/def :parameter/boolean :parameter/base)
(spec/def :parameter/float :parameter/base)
(spec/def :parameter/int :parameter/base)
(spec/def :parameter/multiChoice :parameter/base)
(spec/def :parameter/repoFilter :parameter/base)
(spec/def :parameter/schedule :parameter/base)
(spec/def :parameter/singleChoice :parameter/base)
(spec/def :parameter/string :parameter/base)
(spec/def :parameter/stringArray :parameter/base)
(spec/def :parameter/required boolean?)

(spec/def :skill/parameter (spec/keys :req_un [(or
                                                :parameter/boolean
                                                :parameter/float
                                                :parameter/int
                                                :parameter/multiChoice
                                                :parameter/repoFilter
                                                :parameter/schedule
                                                :parameter/singleChoice
                                                :parameter/string
                                                :parameter/stringArray)]))

(spec/def :skill/resourceProvider (spec/keys :req_un [::name ::typeName]
                                             :opt_un [::description ::maxAllowed ::minRequired]))

(spec/def :skill/command (spec/keys :req_un [::name ::description ::pattern]
                                    :opt_un [::displayName]))

(spec/def :artifact/name string?)
(spec/def :artifact/image string?)
(spec/def :artifact/url string?)
(spec/def :artifact/command string?)
(spec/def :artifact/args (spec/coll-of string?))
(spec/def :artifact/entryPoint string?)
(spec/def :artifact/workingDir string?)
(spec/def :artifact/env (spec/coll-of (spec/keys :req_un [::name ::value])))
(spec/def :artifact/memory int?)
(spec/def :artifact/timeout int?)
(spec/def :artifact/runtime #{"nodejs10" "python37" "go113" "java11"})

(spec/def :gcf/gcf (spec/keys :req_un [:artifact/entryPoint :artifact/runtime :artifact/name]
                              :opt_un [:artifact/memory :artifact/timeout]))
(spec/def :docker/docker (spec/keys :req_un [:artifact/name :artifact/image]
                                    :opt_un [:artifact/args :artifact/command :artifact/env :artifact/workingDir]))

(spec/def :artifact/gcf (spec/coll-of :gcf/gcf))
(spec/def :artifact/docker (spec/coll-of :docker/docker))

(spec/def :skill/commitSha string?)
(spec/def :skill/branchId string?)
(spec/def :skill/repoId string?)
(spec/def :skill/version string?)
(spec/def :skill/author string?)
(spec/def :skill/license string?)
(spec/def :skill/namespace string?)
(spec/def :skill/name #(and (string? %) (re-find #"[\w]*/[\w]*" %)))
(spec/def :skill/readme string?)
(spec/def :skill/longDescription string?)
(spec/def :skill/description string?)
(spec/def :skill/displayName string?)

(spec/def :skill/dispatchStyle #{"single" "multiple"})

(spec/def :skill/iconUrl string?)                           ;; TODO
(spec/def :skill/videoUrl string?)                          ;; TODO
(spec/def :skill/maxConfigurations integer?)

(spec/def :skill/artifacts (spec/keys :req_un [(or :artifact/docker :artifact/gcf)]))
(spec/def :skill/subscriptions (spec/coll-of string?))
(spec/def :skill/resourceProviders (spec/coll-of :skill/resourceProvider))
(spec/def :skill/parameters (spec/coll-of :skill/parameter))
(spec/def :skill/commands (spec/coll-of :skill/command))
(spec/def :skill/technologies #{"JAVA" "JAVASCRIPT" "MAVEN" "DOCKER" "NPM" "LEIN" "CLOJURE" "KUBERNETES"})
(spec/def :skill/categories #{"BUILD" "CODE_REVIEW" "DEV_EX" "DEPLOY" "SECURITY" "DEPENDENCIES" "NOTIFICATIONS" "CI" "CD" "PRODUCTIVITY" "CODE_QUALITY" "CHAT"})

(spec/def :skill/added (spec/keys :req_un [:skill/commitSha :skill/branchId :skill/repoId :skill/version]))

(spec/def :skill/spec (spec/keys :req_un [:skill/artifacts :skill/author :skill/license :skill/longDescription :skill/name :skill/namespace :skill/iconUrl :skill/homepageUrl :skill/description :skill/displayName]
                                 :opt_un [:skill/subscriptions :skill/parameters :skill/readme :skill/resourceProviders :skill/videoUrl :skill/categories :skill/technologies :skill/maxConfigurations :skill/commands :skill/dispatchStyle]))

