(ns atomist.json
  (:require #?@(:cljs [[cljs-node-io.core :as io :refer [slurp spit file-seq]]]
                :clj [[clojure.java.io :as io]
                      [cheshire.core :as json]])))

(defn ->obj [s & {:keys [keywordize-keys] :or {keywordize-keys true}}]
  #?(:cljs (js->clj (js/JSON.parse s) :keywordize-keys keywordize-keys)
     :clj (json/parse-string s keyword)))

(defn ->str [obj]
  #?(:cljs (js/JSON.stringify (clj->js obj) nil 2)
     :clj (json/generate-string obj {:pretty true})))